/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;

public class GradientImage {
    private int[][] h;
    private int[][] v;
    private FastBitmap horizontalBitmap;
    private FastBitmap verticalBitmap;
    private float[][] magnitude;
    private float[][] orientation;
    private int division = 1;

    public int getDivision() {
        return this.division;
    }

    public void setDivision(int division) {
        this.division = division;
    }

    public GradientImage(FastBitmap fastBitmap) {
        this.Compute(fastBitmap);
    }

    public GradientImage(FastBitmap fastBitmap, int[][] horizontal, int[][] vertical) {
        this.h = horizontal;
        this.v = vertical;
        this.Compute(fastBitmap);
    }

    public GradientImage(FastBitmap fastBitmap, int[][] horizontal, int[][] vertical, int division) {
        this.h = horizontal;
        this.v = vertical;
        this.division = division;
        this.Compute(fastBitmap);
    }

    private void Compute(FastBitmap fastBitmap) {
        this.horizontalBitmap = new FastBitmap(fastBitmap);
        this.verticalBitmap = new FastBitmap(fastBitmap);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        Convolution c = new Convolution(this.h, this.division);
        c.applyInPlace(this.horizontalBitmap);
        c.setKernel(this.v);
        c.applyInPlace(this.verticalBitmap);
        this.magnitude = new float[height][width];
        this.orientation = new float[height][width];
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                double H = this.horizontalBitmap.getGray(x, y);
                double V = this.verticalBitmap.getGray(x, y);
                this.magnitude[x][y] = (float)Math.sqrt(H * H + V * V);
                this.orientation[x][y] = (float)Math.atan2(V, H);
            }
        }
    }

    public float getMagnitude(int x, int y) {
        return this.magnitude[x][y];
    }

    public float getMagnitude(IntPoint point) {
        return this.magnitude[point.x][point.y];
    }

    public float[][] getMagnitude() {
        return this.magnitude;
    }

    public float getOrientation(int x, int y) {
        return this.orientation[x][y];
    }

    public float getOrientation(IntPoint point) {
        return this.orientation[point.x][point.y];
    }

    public float[][] getOrientation() {
        return this.orientation;
    }

    public FastBitmap getVerticalImage() {
        return this.verticalBitmap;
    }

    public FastBitmap getHorizontalImage() {
        return this.horizontalBitmap;
    }

    public FastBitmap getMaximumGradient() {
        int width = this.horizontalBitmap.getWidth();
        int height = this.horizontalBitmap.getHeight();
        FastBitmap image = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int g = Math.min(255, this.horizontalBitmap.getGray(i, j) + this.verticalBitmap.getGray(i, j));
                image.setGray(i, j, g);
            }
        }
        return image;
    }
}

