/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.Contour;
import java.util.ArrayList;
import java.util.List;

public class FindContours {
    private static final int[][] delta = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private int[][] labelArray;
    private static final int VISITED = -1;
    private static final int BACKGROUND = 0;
    private static final int START_LABEL = 2;
    private int currentLabel;
    private int maxLabel;
    private List<Contour> outerContours;
    private List<Contour> innerContours;

    public List<Contour> getAllInnerContours() {
        return this.innerContours;
    }

    public List<Contour> getAllOuterContours() {
        return this.outerContours;
    }

    public void Process(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Contour finding only works in grayscale images.");
        }
        this.labelArray = new int[fastBitmap.getWidth() + 2][fastBitmap.getHeight() + 2];
        this.outerContours = new ArrayList<Contour>();
        this.innerContours = new ArrayList<Contour>();
        this.applyLabeling(fastBitmap);
    }

    private int getNextLabel() {
        this.currentLabel = this.currentLabel < 1 ? 2 : ++this.currentLabel;
        this.maxLabel = this.currentLabel;
        return this.currentLabel;
    }

    private void resetLabel() {
        this.currentLabel = -1;
        this.maxLabel = -1;
    }

    private void applyLabeling(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        this.resetLabel();
        boolean isMatrix = false;
        if (fastBitmap.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
            isMatrix = true;
            fastBitmap.setCoordinateSystem(FastBitmap.CoordinateSystem.Cartesian);
        }
        for (int v = 0; v < height; ++v) {
            int label = 0;
            for (int u = 0; u < width; ++u) {
                if (fastBitmap.getGray(u, v) > 0) {
                    if (label != 0) {
                        this.setLabel(u, v, label);
                        continue;
                    }
                    label = this.getLabel(u, v);
                    if (label != 0) continue;
                    label = this.getNextLabel();
                    Contour oc = this.traceContour(u, v, 0, label, fastBitmap, isMatrix);
                    this.outerContours.add(oc);
                    this.setLabel(u, v, label);
                    continue;
                }
                if (label == 0) continue;
                if (this.getLabel(u, v) == 0) {
                    Contour ic = this.traceContour(u - 1, v, 1, label, fastBitmap, isMatrix);
                    this.innerContours.add(ic);
                }
                label = 0;
            }
        }
        if (isMatrix) {
            fastBitmap.setCoordinateSystem(FastBitmap.CoordinateSystem.Matrix);
        }
    }

    private Contour traceContour(int xS, int yS, int dS, int label, FastBitmap fastBitmap, boolean isMatrix) {
        boolean done;
        int yT;
        int xT;
        ArrayList<IntPoint> contour = new ArrayList<IntPoint>();
        IntPoint pt = new IntPoint(xS, yS);
        int dNext = this.findNextPoint(pt, dS, fastBitmap);
        if (isMatrix) {
            contour.add(new IntPoint(pt.y, pt.x));
        } else {
            contour.add(pt);
        }
        int xP = xS;
        int yP = yS;
        int xC = xT = pt.x;
        int yC = yT = pt.y;
        boolean bl = done = xS == xT && yS == yT;
        while (!done) {
            this.setLabel(xC, yC, label);
            pt = new IntPoint(xC, yC);
            int dSearch = (dNext + 6) % 8;
            dNext = this.findNextPoint(pt, dSearch, fastBitmap);
            xP = xC;
            yP = yC;
            xC = pt.x;
            yC = pt.y;
            done = xP == xS && yP == yS && xC == xT && yC == yT;
            if (done) continue;
            if (isMatrix) {
                contour.add(new IntPoint(pt.y, pt.x));
                continue;
            }
            contour.add(pt);
        }
        return new Contour(label, contour);
    }

    private int findNextPoint(IntPoint pt, int dir, FastBitmap fastBitmap) {
        for (int i = 0; i < 7; ++i) {
            int x = pt.x + delta[dir][0];
            int y = pt.y + delta[dir][1];
            if (fastBitmap.getGray(x, y) != 0) {
                pt.x = x;
                pt.y = y;
                break;
            }
            this.setLabel(x, y, -1);
            dir = (dir + 1) % 8;
        }
        return dir;
    }

    public int getLabel(int u, int v) {
        return this.labelArray[u + 1][v + 1];
    }

    private void setLabel(int u, int v, int label) {
        this.labelArray[u + 1][v + 1] = label;
    }
}

