/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.Color;
import Catalano.Imaging.Tools.Illuminant;
import Catalano.Math.Matrix;

public class ColorConverter {
    private static final double[][] hpe_f = new double[][]{{0.38971, 0.68898, -0.07868}, {-0.22981, 1.1834, 0.04641}, {0.0, 0.0, 1.0}};
    private static final double[][] hpe_b = new double[][]{{1.9102, -1.11212, 0.20191}, {0.37095, 0.62905, -1.0E-5}, {0.0, 0.0, 1.0}};
    private static final double[][] bradford_f = new double[][]{{0.8951, 0.2664, -0.1614}, {-0.7502, 1.7135, 0.0367}, {0.0389, -0.0685, 1.0296}};
    private static final double[][] bradford_b = new double[][]{{0.9869929, -0.1470543, 0.1599627}, {0.4323053, 0.5183603, 0.0492912}, {-0.0085287, 0.0400428, 0.9684867}};
    private static final double[][] vonkries_f = new double[][]{{0.4002, 0.7076, -0.0808}, {-0.2263, 1.1653, 0.0457}, {0.0, 0.0, 0.9182}};
    private static final double[][] vonkries_b = new double[][]{{1.86007, -1.12948, 0.2199}, {0.36122, 0.6388, -1.0E-5}, {0.0, 0.0, 1.08909}};
    private static final double[][] cat97_f = new double[][]{{0.8562, 0.3372, -0.1934}, {-0.836, 1.8327, 0.0033}, {0.0357, -0.00469, 1.0112}};
    private static final double[][] cat97_b = new double[][]{{0.9838112, -0.1805292, 0.1887508}, {0.4488317, 0.4632779, 0.0843307}, {-0.0326513, 0.0085222, 0.9826514}};
    private static final double[][] cat02_f = new double[][]{{0.7328, 0.4296, -0.1624}, {-0.7036, 1.6975, 0.0061}, {0.003, 0.0136, 0.9834}};
    private static final double[][] cat02_b = new double[][]{{1.0961238, -0.278869, 0.1827452}, {0.454369, 0.4735332, 0.0720978}, {-0.0096276, -0.005698, 1.0153256}};
    private static double k = 903.2962962962963;
    private static double e = 0.0088564516790356;

    private ColorConverter() {
    }

    public static double[] RGBtoCMYK(Color color) {
        return ColorConverter.RGBtoCMYK(color.r, color.g, color.b);
    }

    public static double[] RGBtoCMYK(int[] rgb) {
        return ColorConverter.RGBtoCMYK(rgb[0], rgb[1], rgb[2]);
    }

    public static double[] RGBtoCMYK(int red, int green, int blue) {
        double[] cmyk = new double[4];
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        double k = 1.0 - Math.max(r, Math.max(g, b));
        double c = (1.0 - r - k) / (1.0 - k);
        double m = (1.0 - g - k) / (1.0 - k);
        double y = (1.0 - b - k) / (1.0 - k);
        cmyk[0] = c;
        cmyk[1] = m;
        cmyk[2] = y;
        cmyk[3] = k;
        return cmyk;
    }

    public static int[] CMYKtoRGB(double[] cmyk) {
        return ColorConverter.CMYKtoRGB(cmyk[0], cmyk[1], cmyk[2], cmyk[3]);
    }

    public static int[] CMYKtoRGB(double c, double m, double y, double k) {
        int[] rgb = new int[]{(int)(255.0 * (1.0 - c) * (1.0 - k)), (int)(255.0 * (1.0 - m) * (1.0 - k)), (int)(255.0 * (1.0 - y) * (1.0 - k))};
        return rgb;
    }

    public static double[] RGBtoIHS(Color color) {
        return ColorConverter.RGBtoCMYK(color.r, color.g, color.b);
    }

    public static double[] RGBtoIHS(int[] rgb) {
        return ColorConverter.RGBtoIHS(rgb[0], rgb[1], rgb[2]);
    }

    public static double[] RGBtoIHS(int red, int green, int blue) {
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        double i = r + g + b;
        double h = b == Math.min(Math.min(r, g), b) ? (g - b) / (i - 3.0 * b) : (r == Math.min(Math.min(r, g), b) ? (b - r) / (i - 3.0 * r) + 1.0 : (r - g) / (i - 3.0 * g) + 2.0);
        double s = h >= 0.0 && h <= 1.0 ? (i - 3.0 * b) / i : (h >= 1.0 && h <= 2.0 ? (i - 3.0 * r) / i : (i - 3.0 * g) / i);
        return new double[]{i, h, s};
    }

    public static double[] IHStoRGB(double[] ihs) {
        if (ihs[1] >= 0.0 && ihs[1] <= 1.0) {
            double r = ihs[0] * (1.0 + 2.0 * ihs[2] - 3.0 * ihs[2] * ihs[1]) / 3.0;
            double g = ihs[0] * (1.0 - ihs[2] + 3.0 * ihs[2] * ihs[1]) / 3.0;
            double b = ihs[0] * (1.0 - ihs[2]) / 3.0;
            return new double[]{r * 255.0, g * 255.0, b * 255.0};
        }
        if (ihs[1] >= 1.0 && ihs[1] <= 2.0) {
            double r = ihs[0] * (1.0 - ihs[2]) / 3.0;
            double g = ihs[0] * (1.0 + 2.0 * ihs[2] - 3.0 * ihs[2] * (ihs[1] - 1.0)) / 3.0;
            double b = ihs[0] * (1.0 - ihs[2] + 3.0 * ihs[2] * (ihs[1] - 1.0)) / 3.0;
            return new double[]{r * 255.0, g * 255.0, b * 255.0};
        }
        double r = ihs[0] * (1.0 - ihs[2] + 3.0 * ihs[2] * (ihs[1] - 2.0)) / 3.0;
        double g = ihs[0] * (1.0 - ihs[2]) / 3.0;
        double b = ihs[0] * (1.0 + 2.0 * ihs[2] - 3.0 * ihs[2] * (ihs[1] - 2.0)) / 3.0;
        return new double[]{r * 255.0, g * 255.0, b * 255.0};
    }

    public static double[] RGBtoYUV(Color color) {
        return ColorConverter.RGBtoYUV(color.r, color.g, color.b);
    }

    public static double[] RGBtoYUV(int red, int green, int blue) {
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        double[] yuv = new double[3];
        double y = 0.299 * r + 0.587 * g + 0.114 * b;
        double u = -0.14713 * r - 0.28886 * g + 0.436 * b;
        double v = 0.615 * r - 0.51499 * g - 0.10001 * b;
        yuv[0] = y;
        yuv[1] = u;
        yuv[2] = v;
        return yuv;
    }

    public static int[] YUVtoRGB(double y, double u, double v) {
        int[] rgb = new int[3];
        double r = (y + 0.0 * u + 1.14 * v) * 255.0;
        double g = (y - 0.396 * u - 0.581 * v) * 255.0;
        double b = (y + 2.029 * u + 0.0 * v) * 255.0;
        rgb[0] = (int)r;
        rgb[1] = (int)g;
        rgb[2] = (int)b;
        return rgb;
    }

    public static double[] RGBtoYIQ(Color color) {
        return ColorConverter.RGBtoYIQ(color.r, color.g, color.b);
    }

    public static double[] RGBtoYIQ(int red, int green, int blue) {
        double[] yiq = new double[3];
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        double y = 0.299 * r + 0.587 * g + 0.114 * b;
        double i = 0.596 * r - 0.275 * g - 0.322 * b;
        double q = 0.212 * r - 0.523 * g + 0.311 * b;
        yiq[0] = y;
        yiq[1] = i;
        yiq[2] = q;
        return yiq;
    }

    public static int[] YIQtoRGB(double y, double i, double q) {
        int[] rgb = new int[3];
        int r = (int)((y + 0.956 * i + 0.621 * q) * 255.0);
        int g = (int)((y - 0.272 * i - 0.647 * q) * 255.0);
        int b = (int)((y - 1.105 * i + 1.702 * q) * 255.0);
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
        return rgb;
    }

    public static double[] RGBtoYCbCr(Color color, YCbCrColorSpace colorSpace) {
        return ColorConverter.RGBtoYCbCr(color.r, color.g, color.b, colorSpace);
    }

    public static double[] RGBtoYCbCr(int red, int green, int blue, YCbCrColorSpace colorSpace) {
        double cr;
        double cb;
        double y;
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        double[] YCbCr = new double[3];
        if (colorSpace == YCbCrColorSpace.ITU_BT_601) {
            y = 0.299 * r + 0.587 * g + 0.114 * b;
            cb = -0.169 * r - 0.331 * g + 0.5 * b;
            cr = 0.5 * r - 0.419 * g - 0.081 * b;
        } else {
            y = 0.2215 * r + 0.7154 * g + 0.0721 * b;
            cb = -0.1145 * r - 0.3855 * g + 0.5 * b;
            cr = 0.5016 * r - 0.4556 * g - 0.0459 * b;
        }
        YCbCr[0] = y;
        YCbCr[1] = cb;
        YCbCr[2] = cr;
        return YCbCr;
    }

    public static int[] YCbCrtoRGB(double y, double cb, double cr, YCbCrColorSpace colorSpace) {
        double b;
        double g;
        double r;
        int[] rgb = new int[3];
        if (colorSpace == YCbCrColorSpace.ITU_BT_601) {
            r = (y + 0.0 * cb + 1.403 * cr) * 255.0;
            g = (y - 0.344 * cb - 0.714 * cr) * 255.0;
            b = (y + 1.773 * cb + 0.0 * cr) * 255.0;
        } else {
            r = (y + 0.0 * cb + 1.5701 * cr) * 255.0;
            g = (y - 0.187 * cb - 0.4664 * cr) * 255.0;
            b = (y + 1.8556 * cb + 0.0 * cr) * 255.0;
        }
        rgb[0] = (int)r;
        rgb[1] = (int)g;
        rgb[2] = (int)b;
        return rgb;
    }

    public static double[] RGChromaticity(Color color) {
        return ColorConverter.RGChromaticity(color.r, color.g, color.b);
    }

    public static double[] RGChromaticity(int red, int green, int blue) {
        double[] color = new double[5];
        double sum = red + green + blue;
        color[0] = (double)red / sum;
        color[1] = (double)green / sum;
        color[2] = 1.0 - color[0] - color[1];
        double rS = color[0] - 0.333;
        double gS = color[1] - 0.333;
        color[3] = Math.sqrt(rS * rS + gS * gS);
        color[4] = Math.atan(rS / gS);
        return color;
    }

    public static double[] RGBtoHSV(Color color) {
        return ColorConverter.RGBtoHSV(color.r, color.g, color.b);
    }

    public static double[] RGBtoHSV(int red, int green, int blue) {
        double[] hsv = new double[3];
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double delta = max - min;
        if (max == min) {
            hsv[0] = 0.0;
        } else if (max == r) {
            hsv[0] = (g - b) / delta * 60.0;
        } else if (max == g) {
            hsv[0] = ((b - r) / delta + 2.0) * 60.0;
        } else if (max == b) {
            hsv[0] = ((r - g) / delta + 4.0) * 60.0;
        }
        hsv[1] = delta == 0.0 ? 0.0 : delta / max;
        hsv[2] = max;
        return hsv;
    }

    public static int[] HSVtoRGB(double hue, double saturation, double value) {
        int[] rgb = new int[3];
        double hi = Math.floor(hue / 60.0) % 6.0;
        double f = hue / 60.0 - Math.floor(hue / 60.0);
        double p = value * (1.0 - saturation);
        double q = value * (1.0 - f * saturation);
        double t = value * (1.0 - (1.0 - f) * saturation);
        if (hi == 0.0) {
            rgb[0] = (int)(value * 255.0);
            rgb[1] = (int)(t * 255.0);
            rgb[2] = (int)(p * 255.0);
        } else if (hi == 1.0) {
            rgb[0] = (int)(q * 255.0);
            rgb[1] = (int)(value * 255.0);
            rgb[2] = (int)(p * 255.0);
        } else if (hi == 2.0) {
            rgb[0] = (int)(p * 255.0);
            rgb[1] = (int)(value * 255.0);
            rgb[2] = (int)(t * 255.0);
        } else if (hi == 3.0) {
            rgb[0] = (int)(p * 255.0);
            rgb[1] = (int)(value * 255.0);
            rgb[2] = (int)(q * 255.0);
        } else if (hi == 4.0) {
            rgb[0] = (int)(t * 255.0);
            rgb[1] = (int)(value * 255.0);
            rgb[2] = (int)(p * 255.0);
        } else if (hi == 5.0) {
            rgb[0] = (int)(value * 255.0);
            rgb[1] = (int)(p * 255.0);
            rgb[2] = (int)(q * 255.0);
        }
        return rgb;
    }

    public static double[] RGBtoYCC(Color color) {
        return ColorConverter.RGBtoYCC(color.r, color.g, color.b);
    }

    public static double[] RGBtoYCC(int red, int green, int blue) {
        double[] ycc = new double[3];
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        double y = (double)0.213f * r + (double)0.419f * g + (double)0.081f * b;
        double c1 = (double)-0.131f * r - (double)0.256f * g + (double)0.387f * b + (double)0.612f;
        double c2 = (double)0.373f * r - (double)0.312f * r - (double)0.061f * b + (double)0.537f;
        ycc[0] = y;
        ycc[1] = c1;
        ycc[2] = c2;
        return ycc;
    }

    public static int[] YCCtoRGB(double y, double c1, double c2) {
        int[] rgb = new int[3];
        double r = (double)0.981f * y + (double)1.315f * (c2 - (double)0.537f);
        double g = (double)0.981f * y - (double)0.311f * (c1 - (double)0.612f) - (double)0.669f * (c2 - (double)0.537f);
        double b = (double)0.981f * y + (double)1.601f * (c1 - (double)0.612f);
        rgb[0] = (int)(r * 255.0);
        rgb[1] = (int)(g * 255.0);
        rgb[2] = (int)(b * 255.0);
        return rgb;
    }

    public static double[] RGBtoYCoCg(Color color) {
        return ColorConverter.RGBtoYCoCg(color.r, color.g, color.b);
    }

    public static double[] RGBtoYCoCg(int red, int green, int blue) {
        double[] yCoCg = new double[3];
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        double y = r / 4.0 + g / 2.0 + b / 4.0;
        double co = r / 2.0 - b / 2.0;
        double cg = -r / 4.0 + g / 2.0 - b / 4.0;
        yCoCg[0] = y;
        yCoCg[1] = co;
        yCoCg[2] = cg;
        return yCoCg;
    }

    public static double[] RGBtoYES(Color color) {
        return ColorConverter.RGBtoYES(color.r, color.g, color.b);
    }

    public static double[] RGBtoYES(int[] rgb) {
        return ColorConverter.RGBtoYES(rgb[0], rgb[1], rgb[2]);
    }

    public static double[] RGBtoYES(int red, int green, int blue) {
        double[] yes = new double[3];
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        yes[0] = r * 0.253 + g * 0.684 + b * 0.063;
        yes[1] = r * 0.5 + g * -0.5;
        yes[2] = r * 0.25 + g * 0.25 + b * -0.5;
        return yes;
    }

    public static int[] YEStoRGB(double[] yes) {
        return ColorConverter.YEStoRGB(yes[0], yes[1], yes[2]);
    }

    public static int[] YEStoRGB(double y, double e, double s) {
        int[] rgb = new int[]{(int)((y + e * 1.431 + s * 0.126) * 255.0), (int)((y + e * -0.569 + s * 0.126) * 255.0), (int)((y + e * 0.431 + s * -1.874) * 255.0)};
        return rgb;
    }

    public static int[] YCoCgtoRGB(double y, double co, double cg) {
        int[] rgb = new int[3];
        double r = y + co - cg;
        double g = y + cg;
        double b = y - co - cg;
        rgb[0] = (int)(r * 255.0);
        rgb[1] = (int)(g * 255.0);
        rgb[2] = (int)(b * 255.0);
        return rgb;
    }

    public static double[] RGBtoXYZ(Color color) {
        return ColorConverter.RGBtoXYZ(color.r, color.g, color.b);
    }

    public static double[] RGBtoXYZ(int red, int green, int blue) {
        return ColorConverter.RGBtoXYZ(new int[]{red, green, blue});
    }

    public static double[] RGBtoXYZ(int[] rgb) {
        double[] xyz = new double[3];
        double r = (double)rgb[0] / 255.0;
        double g = (double)rgb[1] / 255.0;
        double b = (double)rgb[2] / 255.0;
        r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : (r /= 12.92);
        g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : (g /= 12.92);
        b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : (b /= 12.92);
        double x = 0.412453 * (r *= 100.0) + 0.35758 * (g *= 100.0) + 0.180423 * (b *= 100.0);
        double y = 0.212671 * r + 0.71516 * g + 0.072169 * b;
        double z = 0.019334 * r + 0.119193 * g + 0.950227 * b;
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return xyz;
    }

    public static int[] XYZtoRGB(double x, double y, double z) {
        return ColorConverter.XYZtoRGB(new double[]{x, y, z});
    }

    public static int[] XYZtoRGB(double[] xyz) {
        int[] rgb = new int[3];
        double x = xyz[0] / 100.0;
        double y = xyz[1] / 100.0;
        double z = xyz[2] / 100.0;
        double r = 3.240479 * x - 1.53715 * y - 0.498535 * z;
        double g = -0.969256 * x + 1.875991 * y + 0.041556 * z;
        double b = 0.055648 * x - 0.204043 * y + 1.057311 * z;
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : 12.92 * r;
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : 12.92 * g;
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : 12.92 * b;
        r = r < 0.0 ? 0.0 : r;
        g = g < 0.0 ? 0.0 : g;
        b = b < 0.0 ? 0.0 : b;
        r = r > 255.0 ? 255.0 : r;
        g = g > 255.0 ? 255.0 : g;
        b = b > 255.0 ? 255.0 : b;
        rgb[0] = (int)Math.round(r * 255.0);
        rgb[1] = (int)Math.round(g * 255.0);
        rgb[2] = (int)Math.round(b * 255.0);
        return rgb;
    }

    public static double[] XYZtoXyY(double x, double y, double z) {
        return ColorConverter.XYZtoXyY(new double[]{x, y, z});
    }

    public static double[] XYZtoXyY(double[] xyz) {
        double[] xyy = new double[3];
        double sum = xyz[0] + xyz[1] + xyz[2];
        xyy[0] = xyz[0] / sum;
        xyy[1] = xyz[1] / sum;
        xyy[2] = xyz[1];
        return xyy;
    }

    public static double[] XYZtoHunterLAB(double x, double y, double z) {
        double[] hunter = new double[3];
        double sqrt = Math.sqrt(y);
        double l = 10.0 * sqrt;
        double a = 17.5 * (((double)1.02f * x - y) / sqrt);
        double b = 7.0 * ((y - (double)0.847f * z) / sqrt);
        hunter[0] = l;
        hunter[1] = a;
        hunter[2] = b;
        return hunter;
    }

    public static double[] XYZtoLMS(double x, double y, double z) {
        return ColorConverter.XYZtoLMS(new double[]{x, y, z}, LMS.CAT02);
    }

    public static double[] XYZtoLMS(double x, double y, double z, LMS matrix) {
        return ColorConverter.XYZtoLMS(new double[]{x, y, z}, matrix);
    }

    public static double[] XYZtoLMS(double[] xyz) {
        return ColorConverter.XYZtoLMS(xyz, LMS.CAT02);
    }

    public static double[] XYZtoLMS(double[] xyz, LMS matrix) {
        switch (matrix) {
            case HPE: {
                return Matrix.Multiply(xyz, hpe_f);
            }
            case Bradford: {
                return Matrix.Multiply(xyz, bradford_f);
            }
            case VonKries: {
                return Matrix.Multiply(xyz, vonkries_f);
            }
            case CAT97: {
                return Matrix.Multiply(xyz, cat97_f);
            }
        }
        return Matrix.Multiply(xyz, cat02_f);
    }

    public static double[] XYYtoXYZ(double x, double y, double Y) {
        return ColorConverter.XYYtoXYZ(new double[]{x, y, Y});
    }

    public static double[] XYYtoXYZ(double[] xyY) {
        double x = xyY[0] * xyY[2] / xyY[1];
        double z = (1.0 - xyY[0] - xyY[1]) * xyY[2] / xyY[1];
        return new double[]{x, xyY[2], z};
    }

    public static double[] HunterLABtoXYZ(double l, double a, double b) {
        double[] xyz = new double[3];
        double tempY = l / 10.0;
        double tempX = a / 17.5 * l / 10.0;
        double tempZ = b / 7.0 * l / 10.0;
        double y = tempY * tempY;
        double x = (tempX + y) / (double)1.02f;
        double z = -(tempZ - y) / (double)0.847f;
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return xyz;
    }

    public static double[] RGBtoHunterLAB(Color color) {
        return ColorConverter.RGBtoHunterLAB(color.r, color.g, color.b);
    }

    public static double[] RGBtoHunterLAB(int red, int green, int blue) {
        double[] xyz = ColorConverter.RGBtoXYZ(red, green, blue);
        return ColorConverter.XYZtoHunterLAB(xyz[0], xyz[1], xyz[2]);
    }

    public static int[] HunterLABtoRGB(double l, double a, double b) {
        double[] xyz = ColorConverter.HunterLABtoXYZ(l, a, b);
        return ColorConverter.XYZtoRGB(xyz[0], xyz[1], xyz[2]);
    }

    public static double[] RGBtoHSL(Color color) {
        return ColorConverter.RGBtoHSL(color.r, color.g, color.b);
    }

    public static double[] RGBtoHSL(int red, int green, int blue) {
        double[] hsl = new double[3];
        double r = (float)red / 255.0f;
        double g = (float)green / 255.0f;
        double b = (float)blue / 255.0f;
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double delta = max - min;
        double h = 0.0;
        double s = 0.0;
        double l = (max + min) / 2.0;
        if (delta == 0.0) {
            h = 0.0;
            s = 0.0;
        } else {
            double d = s = l <= 0.5 ? delta / (max + min) : delta / (2.0 - max - min);
            double hue = r == max ? (g - b) / 6.0 / delta : (g == max ? 0.3333333432674408 + (b - r) / 6.0 / delta : 0.6666666865348816 + (r - g) / 6.0 / delta);
            if (hue < 0.0) {
                hue += 1.0;
            }
            if (hue > 1.0) {
                hue -= 1.0;
            }
            h = (int)(hue * 360.0);
        }
        hsl[0] = h;
        hsl[1] = s;
        hsl[2] = l;
        return hsl;
    }

    public static int[] HSLtoRGB(double hue, double saturation, double luminance) {
        int[] rgb = new int[3];
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (saturation == 0.0) {
            g = b = (double)((int)(luminance * 255.0));
            r = b;
        } else {
            double h = hue / 360.0;
            double v2 = luminance < 0.5 ? luminance * (1.0 + saturation) : luminance + saturation - luminance * saturation;
            double v1 = 2.0 * luminance - v2;
            r = (int)(255.0 * ColorConverter.Hue_2_RGB(v1, v2, h + 0.3333333432674408));
            g = (int)(255.0 * ColorConverter.Hue_2_RGB(v1, v2, h));
            b = (int)(255.0 * ColorConverter.Hue_2_RGB(v1, v2, h - 0.3333333432674408));
        }
        rgb[0] = (int)r;
        rgb[1] = (int)g;
        rgb[2] = (int)b;
        return rgb;
    }

    private static double Hue_2_RGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666865348816 - vH) * 6.0;
        }
        return v1;
    }

    public static double[] RGBtoLAB(int[] rgb) {
        return ColorConverter.RGBtoLAB(rgb, Illuminant.CIE2.D65);
    }

    public static double[] RGBtoLAB(int[] rgb, double[] tristimulus) {
        double[] xyz = ColorConverter.RGBtoXYZ(rgb);
        return ColorConverter.XYZtoLAB(xyz, tristimulus);
    }

    public static double[] RGBtoLAB(Color color, double[] tristimulus) {
        return ColorConverter.RGBtoLAB(color.r, color.g, color.b, tristimulus);
    }

    public static double[] RGBtoLAB(int red, int green, int blue) {
        return ColorConverter.RGBtoLAB(red, green, blue, Illuminant.CIE2.D65);
    }

    public static double[] RGBtoLAB(int red, int green, int blue, double[] tristimulus) {
        double[] xyz = ColorConverter.RGBtoXYZ(red, green, blue);
        double[] lab = ColorConverter.XYZtoLAB(xyz[0], xyz[1], xyz[2], tristimulus);
        return lab;
    }

    public static double[] RGBtoLCH(Color color) {
        return ColorConverter.RGBtoLCH(color.r, color.g, color.b);
    }

    public static double[] RGBtoLCH(int red, int green, int blue) {
        return ColorConverter.RGBtoLCH(red, green, blue, Illuminant.CIE2.D65);
    }

    public static double[] RGBtoLCH(int red, int green, int blue, double[] tristimulus) {
        double[] lab = ColorConverter.RGBtoLAB(red, green, blue, tristimulus);
        return ColorConverter.LABtoLCH(lab[0], lab[1], lab[2]);
    }

    public static double[] RGBtoLMS(int red, int green, int blue) {
        return ColorConverter.RGBtoLMS(new int[]{red, green, blue}, LMS.CAT02);
    }

    public static double[] RGBtoLMS(int red, int green, int blue, LMS matrix) {
        return ColorConverter.RGBtoLMS(new int[]{red, green, blue}, matrix);
    }

    public static double[] RGBtoLMS(int[] rgb) {
        return ColorConverter.RGBtoLMS(rgb, LMS.CAT02);
    }

    public static double[] RGBtoLMS(int[] rgb, LMS matrix) {
        double[] xyz = ColorConverter.RGBtoXYZ(rgb);
        return ColorConverter.XYZtoLMS(xyz, matrix);
    }

    public static int[] LABtoRGB(double[] lab) {
        return ColorConverter.LABtoRGB(lab[0], lab[1], lab[2], Illuminant.CIE2.D65);
    }

    public static int[] LABtoRGB(double[] lab, double[] tristimulus) {
        return ColorConverter.LABtoRGB(lab[0], lab[1], lab[2], tristimulus);
    }

    public static int[] LABtoRGB(double l, double a, double b) {
        return ColorConverter.LABtoRGB(l, a, b, Illuminant.CIE2.D65);
    }

    public static int[] LABtoRGB(double l, double a, double b, double[] tristimulus) {
        double[] xyz = ColorConverter.LABtoXYZ(l, a, b, tristimulus);
        return ColorConverter.XYZtoRGB(xyz[0], xyz[1], xyz[2]);
    }

    public static double[] LABtoLCH(double[] lab) {
        return ColorConverter.LABtoLCH(lab[0], lab[1], lab[2]);
    }

    public static double[] LABtoLCH(double l, double a, double b) {
        double[] lch = new double[3];
        double h = Math.toDegrees(Math.atan2(b, a));
        if (h < 0.0) {
            h += 360.0;
        }
        lch[0] = l;
        lch[1] = Math.sqrt(a * a + b * b);
        lch[2] = h;
        return lch;
    }

    public static int[] LMStoRGB(double l, double m, double s) {
        return ColorConverter.LMStoRGB(new double[]{l, m, s}, LMS.CAT02);
    }

    public static int[] LMStoRGB(double l, double m, double s, LMS matrix) {
        return ColorConverter.LMStoRGB(new double[]{l, m, s}, matrix);
    }

    public static int[] LMStoRGB(double[] lms) {
        return ColorConverter.LMStoRGB(lms, LMS.CAT02);
    }

    public static int[] LMStoRGB(double[] lms, LMS matrix) {
        double[] xyz = ColorConverter.LMStoXYZ(lms, matrix);
        return ColorConverter.XYZtoRGB(xyz);
    }

    public static double[] XYZtoLAB(double[] xyz) {
        return ColorConverter.XYZtoLAB(xyz, Illuminant.CIE2.D65);
    }

    public static double[] XYZtoLAB(double[] xyz, double[] tristimulus) {
        return ColorConverter.XYZtoLAB(xyz[0], xyz[1], xyz[2], tristimulus);
    }

    public static double[] XYZtoLAB(double x, double y, double z, double[] tristimulus) {
        double[] lab = new double[3];
        x /= tristimulus[0];
        y /= tristimulus[1];
        z /= tristimulus[2];
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787036 * x + 0.1379310344827586;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787036 * y + 0.1379310344827586;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787036 * z + 0.1379310344827586;
        lab[0] = 116.0 * y - 16.0;
        lab[1] = 500.0 * (x - y);
        lab[2] = 200.0 * (y - z);
        return lab;
    }

    public static double[] LABtoXYZ(double l, double a, double b, double[] tristimulus) {
        double[] xyz = new double[3];
        double y = (l + 16.0) / 116.0;
        double x = a / 500.0 + y;
        double z = y - b / 200.0;
        x = Math.pow(x, 3.0) > e ? Math.pow(x, 3.0) : (116.0 * x - 16.0) / k;
        y = l > 8.0 ? Math.pow((l + 16.0) / 116.0, 3.0) : l / k;
        z = Math.pow(z, 3.0) > e ? Math.pow(z, 3.0) : (116.0 * z - 16.0) / k;
        xyz[0] = x * tristimulus[0];
        xyz[1] = y * tristimulus[1];
        xyz[2] = z * tristimulus[2];
        return xyz;
    }

    public static double[] LCHtoLAB(double l, double c, double h) {
        double[] lab = new double[]{l, c * Math.cos(Math.toRadians(h)), c * Math.sin(Math.toRadians(h))};
        return lab;
    }

    public static int[] LCHtoRGB(double l, double c, double h) {
        double[] lab = ColorConverter.LCHtoLAB(l, c, h);
        return ColorConverter.LABtoRGB(lab[0], lab[1], lab[2], Illuminant.CIE2.D65);
    }

    public static double[] LMStoXYZ(double l, double m, double s, LMS matrix) {
        return ColorConverter.LMStoXYZ(new double[]{l, m, s}, matrix);
    }

    public static double[] LMStoXYZ(double[] lms, LMS matrix) {
        switch (matrix) {
            case HPE: {
                return Matrix.Multiply(lms, hpe_b);
            }
            case Bradford: {
                return Matrix.Multiply(lms, bradford_b);
            }
            case VonKries: {
                return Matrix.Multiply(lms, vonkries_b);
            }
            case CAT97: {
                return Matrix.Multiply(lms, cat97_b);
            }
        }
        return Matrix.Multiply(lms, cat02_b);
    }

    public static double[] RGBtoC1C2C3(Color color) {
        return ColorConverter.RGBtoC1C2C3(color.r, color.g, color.b);
    }

    public static double[] RGBtoC1C2C3(int r, int g, int b) {
        double[] c = new double[]{Math.atan(r / Math.max(g, b)), Math.atan(g / Math.max(r, b)), Math.atan(b / Math.max(r, g))};
        return c;
    }

    public static double[] RGBtoO1O2(Color color) {
        return ColorConverter.RGBtoO1O2(color.r, color.g, color.b);
    }

    public static double[] RGBtoO1O2(int r, int g, int b) {
        double[] o = new double[]{(float)(r - g) / 2.0f, (float)(r + g) / 4.0f - (float)b / 2.0f};
        return o;
    }

    public static double RGBtoGrayscale(Color color) {
        return ColorConverter.RGBtoGrayscale(color.r, color.g, color.b);
    }

    public static double RGBtoGrayscale(int r, int g, int b) {
        return (float)r * 0.2125f + (float)g * 0.7154f + (float)b * 0.0721f;
    }

    public static enum YCbCrColorSpace {
        ITU_BT_601,
        ITU_BT_709_HDTV;

    }

    public static enum LMS {
        HPE,
        Bradford,
        VonKries,
        CAT97,
        CAT02;

    }
}

