/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Shapes.IntRectangle;
import Catalano.Imaging.Tools.Blob;
import Catalano.Math.Geometry.PointsCloud;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BlobDetection {
    private Algorithm algorithm = Algorithm.FourWay;
    private int width;
    private int height;
    private FastBitmap copy;
    private int size;
    private int rR = 0;
    private int rG = 0;
    private int rB = 0;
    private List<Blob> blobs;
    private Blob blob;
    private int id = 0;
    private boolean filterBlob = false;
    private int minArea = 1;
    private int maxArea;
    private int idBigBlob;
    private int areaBig = 0;

    public BlobDetection() {
    }

    public BlobDetection(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public int size() {
        return this.size;
    }

    public boolean isFilterBlob() {
        return this.filterBlob;
    }

    public void setFilterBlob(boolean bool) {
        this.filterBlob = bool;
    }

    public int getMaxArea() {
        return this.maxArea;
    }

    public void setMaxArea(int maxArea) {
        this.maxArea = maxArea;
    }

    public int getMinArea() {
        return this.minArea;
    }

    public void setMinArea(int minArea) {
        this.minArea = minArea;
    }

    public int getIdBiggestBlob() {
        return this.idBigBlob;
    }

    public List<Blob> ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.width = fastBitmap.getWidth();
            this.height = fastBitmap.getHeight();
            if (this.maxArea == 0) {
                this.maxArea = this.width * this.height;
            }
            this.copy = new FastBitmap(fastBitmap);
            this.copy.toRGB();
            this.blobs = new ArrayList<Blob>();
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    if (this.copy.getRed(x, y) != 255) continue;
                    this.ShuffleColor();
                    this.TagBlob(x, y, this.rR, this.rG, this.rB);
                }
            }
            return this.blobs;
        }
        throw new IllegalArgumentException("Blob detection only works in grayscale images.");
    }

    private void ShuffleColor() {
        if (this.rB == 255) {
            if (this.rG == 255) {
                if (this.rR == 255) {
                    this.rB = 0;
                    this.rG = 0;
                    this.rR = 0;
                }
                ++this.rR;
                this.rG = 0;
            } else {
                ++this.rG;
                this.rB = 0;
            }
        } else {
            ++this.rB;
        }
    }

    private void TagBlob(int x, int y, int r, int g, int b) {
        int h;
        List<IntPoint> lst;
        ArrayList<IntPoint> blobPoints = new ArrayList<IntPoint>();
        LinkedList<IntPoint> examList = new LinkedList<IntPoint>();
        int xc = 0;
        int yc = 0;
        int blobArea = 0;
        int iR = this.copy.getRed(x, y);
        int iG = this.copy.getGreen(x, y);
        int iB = this.copy.getBlue(x, y);
        int iRGB = iR << 16 | iG << 8 | iB;
        examList.addFirst(new IntPoint(x, y));
        switch (this.algorithm) {
            case FourWay: {
                int _RGB;
                IntPoint p;
                while (examList.size() > 0) {
                    int _b;
                    int _g;
                    p = (IntPoint)examList.removeLast();
                    int _r = this.copy.getRed(p.x, p.y);
                    _RGB = _r << 16 | (_g = this.copy.getGreen(p.x, p.y)) << 8 | (_b = this.copy.getBlue(p.x, p.y));
                    if (_RGB != iRGB) continue;
                    x = p.x;
                    y = p.y;
                    this.copy.setRGB(x, y, r, g, b);
                    ++blobArea;
                    blobPoints.add(new IntPoint(x, y));
                    xc += p.x;
                    yc += p.y;
                    if (x - 1 >= 0) {
                        examList.addFirst(new IntPoint(x - 1, y));
                    }
                    if (x + 1 < this.height) {
                        examList.addFirst(new IntPoint(x + 1, y));
                    }
                    if (y - 1 >= 0) {
                        examList.addFirst(new IntPoint(x, y - 1));
                    }
                    if (y + 1 >= this.width) continue;
                    examList.addFirst(new IntPoint(x, y + 1));
                }
                break;
            }
            case EightWay: {
                int _RGB;
                IntPoint p;
                while (examList.size() > 0) {
                    int _b;
                    int _g;
                    p = (IntPoint)examList.removeLast();
                    int _r = this.copy.getRed(p.x, p.y);
                    _RGB = _r << 16 | (_g = this.copy.getGreen(p.x, p.y)) << 8 | (_b = this.copy.getBlue(p.x, p.y));
                    if (_RGB != iRGB) continue;
                    x = p.x;
                    y = p.y;
                    this.copy.setRGB(x, y, r, g, b);
                    ++blobArea;
                    blobPoints.add(new IntPoint(x, y));
                    xc += p.x;
                    yc += p.y;
                    if (x - 1 >= 0 && y - 1 >= 0) {
                        examList.addFirst(new IntPoint(x - 1, y - 1));
                    }
                    if (x - 1 >= 0) {
                        examList.addFirst(new IntPoint(x - 1, y));
                    }
                    if (x - 1 >= 0 && y + 1 < this.width) {
                        examList.addFirst(new IntPoint(x - 1, y + 1));
                    }
                    if (y - 1 >= 0) {
                        examList.addFirst(new IntPoint(x, y - 1));
                    }
                    if (y + 1 < this.width) {
                        examList.addFirst(new IntPoint(x, y + 1));
                    }
                    if (x + 1 < this.height && y - 1 >= 0) {
                        examList.addFirst(new IntPoint(x + 1, y - 1));
                    }
                    if (x + 1 < this.height) {
                        examList.addFirst(new IntPoint(x + 1, y));
                    }
                    if (x + 1 >= this.height || y + 1 >= this.width) continue;
                    examList.addFirst(new IntPoint(x + 1, y + 1));
                }
                break;
            }
        }
        if (this.filterBlob) {
            if (blobArea > this.minArea && blobArea < this.maxArea) {
                if (blobArea > this.areaBig) {
                    this.areaBig = blobArea;
                    this.idBigBlob = this.id;
                }
                lst = PointsCloud.GetBoundingRectangle(blobPoints);
                h = Math.abs(lst.get((int)0).x - lst.get((int)1).x);
                int w = Math.abs(lst.get((int)0).y - lst.get((int)1).y);
                this.blob = new Blob(this.id, blobArea, new IntPoint(xc / blobArea, yc / blobArea), blobPoints, new IntRectangle(lst.get((int)0).x, lst.get((int)0).y, w, h));
                this.blobs.add(this.blob);
                ++this.size;
                ++this.id;
            }
        } else {
            if (blobArea > this.areaBig) {
                this.areaBig = blobArea;
                this.idBigBlob = this.id;
            }
            lst = PointsCloud.GetBoundingRectangle(blobPoints);
            h = Math.abs(lst.get((int)0).x - lst.get((int)1).x);
            int w = Math.abs(lst.get((int)0).y - lst.get((int)1).y);
            this.blob = new Blob(this.id, blobArea, new IntPoint(xc / blobArea, yc / blobArea), blobPoints, new IntRectangle(lst.get((int)0).x, lst.get((int)0).y, w, h));
            this.blobs.add(this.blob);
            ++this.size;
            ++this.id;
        }
    }

    public static enum Algorithm {
        FourWay,
        EightWay;

    }
}

