/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture;

public final class RunLengthFeatures {
    private RunLengthFeatures() {
    }

    public static double ShortRunEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 0; i < runMatrix.length; ++i) {
            for (int j = 1; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] / (double)(j * j);
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double LongRunEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 0; i < runMatrix.length; ++i) {
            for (int j = 1; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] * (double)j * (double)j;
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double LowGrayLevelEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            for (int j = 0; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] / (double)(i * i);
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double HighGrayLevelEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            for (int j = 0; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] * (double)i * (double)i;
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double ShortRunLowGrayLevelEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            for (int j = 1; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] / (double)(i * i * (j * j));
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double ShortRunHighGrayLevelEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            for (int j = 1; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] * (double)i * (double)i / (double)(j * j);
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double LongRunLowGrayLevelEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            for (int j = 1; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] * (double)j * (double)j / (double)(i * i);
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double LongRunHighGrayLevelEmphasis(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            for (int j = 1; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j] * (double)j * (double)j * (double)i * (double)i;
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double GrayLevelNonUniformity(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        double sumJ = 0.0;
        for (int i = 1; i < runMatrix.length; ++i) {
            r += sumJ * sumJ;
            for (int j = 1; j < runMatrix[0].length; ++j) {
                sumJ += runMatrix[i][j];
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double RunLengthNonUniformity(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        double sumI = 0.0;
        for (int j = 1; j < runMatrix[0].length; ++j) {
            r += sumI * sumI;
            for (int i = 1; i < runMatrix.length; ++i) {
                sumI += runMatrix[i][j];
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double GrayLevelDistribution(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int i = 0; i < runMatrix.length; ++i) {
            for (int j = 0; j < runMatrix[0].length; ++j) {
                r += Math.pow(runMatrix[i][j] * (double)j * (double)j, 2.0);
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double RunLenghtDistribution(double[][] runMatrix, int numberPrimitives) {
        double r = 0.0;
        for (int j = 0; j < runMatrix[0].length; ++j) {
            for (int i = 0; i < runMatrix.length; ++i) {
                r += Math.pow(runMatrix[i][j] * (double)i * (double)i, 2.0);
            }
        }
        return r / (double)numberPrimitives;
    }

    public static double RunPercentage(double[][] runMatrix, int numberPossiblePrimitives) {
        double r = 0.0;
        for (int i = 0; i < runMatrix.length; ++i) {
            for (int j = 0; j < runMatrix[0].length; ++j) {
                r += runMatrix[i][j];
            }
        }
        return r / (double)numberPossiblePrimitives;
    }
}

