/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture;

import Catalano.Math.Tools;

public final class HaralickDescriptors {
    public double[] getFeatures(double[][] coocurrenceMatrix) {
        double[] f = new double[]{HaralickDescriptors.ClusterProminence(coocurrenceMatrix), HaralickDescriptors.ClusterShade(coocurrenceMatrix), HaralickDescriptors.ClusterTendency(coocurrenceMatrix), HaralickDescriptors.Contrast(coocurrenceMatrix), HaralickDescriptors.Correlation(coocurrenceMatrix), HaralickDescriptors.Energy(coocurrenceMatrix), HaralickDescriptors.Entropy(coocurrenceMatrix), HaralickDescriptors.Inertia(coocurrenceMatrix), HaralickDescriptors.InverseDifference(coocurrenceMatrix), HaralickDescriptors.InverseDifferenceMoment(coocurrenceMatrix), HaralickDescriptors.TextureHomogeneity(coocurrenceMatrix)};
        return f;
    }

    public static double Energy(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += coocurrenceMatrix[i][j] * coocurrenceMatrix[i][j];
            }
        }
        return r;
    }

    public static double Entropy(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += coocurrenceMatrix[i][j] * Tools.Log(coocurrenceMatrix[i][j] + 1.0, 2.0);
            }
        }
        return -r;
    }

    public static double Contrast(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += (double)Math.abs(i - j) * coocurrenceMatrix[i][j];
            }
        }
        return r;
    }

    public static double Inertia(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += Math.pow(i - j, 2.0) * coocurrenceMatrix[i][j];
            }
        }
        return r;
    }

    public static double Correlation(double[][] coocurrenceMatrix) {
        double meanI = 0.0;
        double stdI = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            int j;
            for (j = 0; j < coocurrenceMatrix[0].length; ++j) {
                meanI += coocurrenceMatrix[i][j];
            }
            for (j = 0; j < coocurrenceMatrix[0].length; ++j) {
                stdI += Math.pow((double)i - meanI, 2.0) * coocurrenceMatrix[i][j];
            }
        }
        double meanJ = 0.0;
        double stdJ = 0.0;
        for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
            int i;
            for (i = 0; i < coocurrenceMatrix.length; ++i) {
                meanJ += coocurrenceMatrix[i][j];
            }
            for (i = 0; i < coocurrenceMatrix.length; ++i) {
                stdJ += Math.pow((double)j - meanJ, 2.0) * coocurrenceMatrix[i][j];
            }
        }
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += ((double)(i * j) * coocurrenceMatrix[i][j] - meanI * meanJ) / stdI * stdJ;
            }
        }
        return r;
    }

    public static double TextureHomogeneity(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += coocurrenceMatrix[i][j] / (double)(1 + Math.abs(i - j));
            }
        }
        return r;
    }

    public static double InverseDifference(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += coocurrenceMatrix[i][j] / (double)(1 + Math.abs(i - j));
            }
        }
        return r;
    }

    public static double InverseDifferenceMoment(double[][] coocurrenceMatrix) {
        double r = 0.0;
        for (int i = 0; i < coocurrenceMatrix.length; ++i) {
            for (int j = 0; j < coocurrenceMatrix[0].length; ++j) {
                r += coocurrenceMatrix[i][j] / (1.0 + Math.pow(i - j, 2.0));
            }
        }
        return r;
    }

    public static double ClusterTendency(double[][] coocurrenceMatrix) {
        double[] meanI = new double[coocurrenceMatrix.length];
        double[] meanJ = new double[coocurrenceMatrix[0].length];
        int i = 0;
        while (i < meanI.length) {
            for (int j = 0; j < coocurrenceMatrix.length; ++j) {
                int n = i;
                meanI[n] = meanI[n] + coocurrenceMatrix[i][j];
            }
            int n = i++;
            meanI[n] = meanI[n] / (double)coocurrenceMatrix.length;
        }
        int j = 0;
        while (j < meanJ.length) {
            for (int i2 = 0; i2 < coocurrenceMatrix.length; ++i2) {
                int n = i2;
                meanJ[n] = meanJ[n] + coocurrenceMatrix[i2][j];
            }
            int n = j++;
            meanJ[n] = meanJ[n] / (double)coocurrenceMatrix[0].length;
        }
        double r = 0.0;
        for (int i3 = 0; i3 < coocurrenceMatrix.length; ++i3) {
            for (int j2 = 0; j2 < coocurrenceMatrix[0].length; ++j2) {
                r += Math.pow((double)i3 - meanI[i3] + ((double)j2 - meanJ[j2]), 2.0) * coocurrenceMatrix[i3][j2];
            }
        }
        return r;
    }

    public static double ClusterShade(double[][] coocurrenceMatrix) {
        double[] meanI = new double[coocurrenceMatrix.length];
        double[] meanJ = new double[coocurrenceMatrix[0].length];
        int i = 0;
        while (i < meanI.length) {
            for (int j = 0; j < coocurrenceMatrix.length; ++j) {
                int n = i;
                meanI[n] = meanI[n] + coocurrenceMatrix[i][j];
            }
            int n = i++;
            meanI[n] = meanI[n] / (double)coocurrenceMatrix.length;
        }
        int j = 0;
        while (j < meanJ.length) {
            for (int i2 = 0; i2 < coocurrenceMatrix.length; ++i2) {
                int n = i2;
                meanJ[n] = meanJ[n] + coocurrenceMatrix[i2][j];
            }
            int n = j++;
            meanJ[n] = meanJ[n] / (double)coocurrenceMatrix[0].length;
        }
        double r = 0.0;
        for (int i3 = 0; i3 < coocurrenceMatrix.length; ++i3) {
            for (int j2 = 0; j2 < coocurrenceMatrix[0].length; ++j2) {
                r += Math.pow((double)i3 - meanI[i3] + ((double)j2 - meanJ[j2]), 3.0) * coocurrenceMatrix[i3][j2];
            }
        }
        return r;
    }

    public static double ClusterProminence(double[][] coocurrenceMatrix) {
        double[] meanI = new double[coocurrenceMatrix.length];
        double[] meanJ = new double[coocurrenceMatrix[0].length];
        int i = 0;
        while (i < meanI.length) {
            for (int j = 0; j < coocurrenceMatrix.length; ++j) {
                int n = i;
                meanI[n] = meanI[n] + coocurrenceMatrix[i][j];
            }
            int n = i++;
            meanI[n] = meanI[n] / (double)coocurrenceMatrix.length;
        }
        int j = 0;
        while (j < meanJ.length) {
            for (int i2 = 0; i2 < coocurrenceMatrix.length; ++i2) {
                int n = i2;
                meanJ[n] = meanJ[n] + coocurrenceMatrix[i2][j];
            }
            int n = j++;
            meanJ[n] = meanJ[n] / (double)coocurrenceMatrix[0].length;
        }
        double r = 0.0;
        for (int i3 = 0; i3 < coocurrenceMatrix.length; ++i3) {
            for (int j2 = 0; j2 < coocurrenceMatrix[0].length; ++j2) {
                r += Math.pow((double)i3 - meanI[i3] + ((double)j2 - meanJ[j2]), 4.0) * coocurrenceMatrix[i3][j2];
            }
        }
        return r;
    }
}

