/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture.BinaryPattern;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Texture.BinaryPattern.IBinaryPattern;
import Catalano.Imaging.Tools.ImageHistogram;

public class GradientLocalBinaryPattern
implements IBinaryPattern {
    @Override
    public ImageHistogram ComputeFeatures(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            try {
                throw new Exception("GLBP works only with grayscale images.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[256];
        for (int x = 1; x < height; ++x) {
            for (int y = 1; y < width; ++y) {
                int cp = fastBitmap.getGray(x, y);
                int grad = (int)(0.5 * (double)(Math.abs(fastBitmap.getGray(x - 1, y - 1) - fastBitmap.getGray(x, y)) + Math.abs(fastBitmap.getGray(x + 1, y) - fastBitmap.getGray(x - 1, y))));
                int sum = 0;
                if (grad - Math.abs(fastBitmap.getGray(x - 1, y - 1) - cp) >= 0) {
                    sum += 128;
                }
                if (grad - Math.abs(fastBitmap.getGray(x - 1, y) - cp) >= 0) {
                    sum += 64;
                }
                if (grad - Math.abs(fastBitmap.getGray(x - 1, y + 1) - cp) >= 0) {
                    sum += 32;
                }
                if (grad - Math.abs(fastBitmap.getGray(x, y + 1) - cp) >= 0) {
                    sum += 16;
                }
                if (grad - Math.abs(fastBitmap.getGray(x + 1, y + 1) - cp) >= 0) {
                    sum += 8;
                }
                if (grad - Math.abs(fastBitmap.getGray(x + 1, y) - cp) >= 0) {
                    sum += 4;
                }
                if (grad - Math.abs(fastBitmap.getGray(x + 1, y - 1) - cp) >= 0) {
                    sum += 2;
                }
                if (grad - Math.abs(fastBitmap.getGray(x, y - 1) - cp) >= 0) {
                    // empty if block
                }
                int n = ++sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

