/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ZhangSuenThinning
implements IApplyInPlace {
    private int[] table = new int[]{0, 0, 0, 0, 0, 0, 1, 3, 0, 0, 3, 1, 1, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 2, 0, 0, 0, 3, 1, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 1, 3, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0};
    private int[] table2 = new int[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int pixelsRemoved;
            int pass = 0;
            do {
                pixelsRemoved = this.thin(pass++, this.table, fastBitmap);
            } while ((pixelsRemoved += this.thin(pass++, this.table, fastBitmap)) > 0);
            do {
                pixelsRemoved = this.thin(pass++, this.table2, fastBitmap);
            } while ((pixelsRemoved += this.thin(pass++, this.table2, fastBitmap)) > 0);
        } else {
            throw new IllegalArgumentException("Zhang Suen Thinning only works with grayscale image.");
        }
    }

    private int thin(int pass, int[] table, FastBitmap fastBitmap) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        byte[] pixels = fastBitmap.getGrayData();
        byte[] pixels2 = new byte[width * height];
        System.arraycopy(fastBitmap.getGrayData(), 0, pixels2, 0, width * height);
        int rowOffset = width;
        int pixelsRemoved = 0;
        for (int y = 1; y <= height - 2; ++y) {
            int offset = y * width + 1;
            for (int x = 1; x <= width - 2; ++x) {
                byte p5 = pixels2[offset];
                byte v = p5;
                if (v != 0) {
                    byte p1 = pixels2[offset - rowOffset - 1];
                    byte p2 = pixels2[offset - rowOffset];
                    byte p3 = pixels2[offset - rowOffset + 1];
                    byte p4 = pixels2[offset - 1];
                    byte p6 = pixels2[offset + 1];
                    byte p7 = pixels2[offset + rowOffset - 1];
                    byte p8 = pixels2[offset + rowOffset];
                    byte p9 = pixels2[offset + rowOffset + 1];
                    int index = 0;
                    if (p1 != 0) {
                        index |= 1;
                    }
                    if (p2 != 0) {
                        index |= 2;
                    }
                    if (p3 != 0) {
                        index |= 4;
                    }
                    if (p6 != 0) {
                        index |= 8;
                    }
                    if (p9 != 0) {
                        index |= 0x10;
                    }
                    if (p8 != 0) {
                        index |= 0x20;
                    }
                    if (p7 != 0) {
                        index |= 0x40;
                    }
                    if (p4 != 0) {
                        index |= 0x80;
                    }
                    int code = table[index];
                    if ((pass & 1) == 1) {
                        if (code == 2 || code == 3) {
                            v = 0;
                            ++pixelsRemoved;
                        }
                    } else if (code == 1 || code == 3) {
                        v = 0;
                        ++pixelsRemoved;
                    }
                }
                pixels[offset++] = v;
            }
        }
        return pixelsRemoved;
    }
}

