/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Integral.IntegralMean;
import Catalano.Imaging.Filters.Integral.IntegralVariance;
import Catalano.Imaging.IApplyInPlace;

public class WolfJolionThreshold
implements IApplyInPlace {
    private int radius = 15;
    private double k = 0.5;
    private double r = 128.0;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public WolfJolionThreshold() {
    }

    public WolfJolionThreshold(int radius) {
        this.radius = radius;
    }

    public WolfJolionThreshold(double k, double r) {
        this.k = k;
        this.r = r;
    }

    public WolfJolionThreshold(int radius, double k, double r) {
        this.radius = radius;
        this.k = k;
        this.r = r;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int i;
            FastBitmap mean = new FastBitmap(fastBitmap);
            FastBitmap var = new FastBitmap(fastBitmap);
            IntegralMean im = new IntegralMean(this.radius);
            im.applyInPlace(mean);
            IntegralVariance iv = new IntegralVariance(this.radius);
            iv.applyInPlace(var);
            int size = fastBitmap.getSize();
            int maxV = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                int g = var.getGray(i2);
                if (g <= maxV) continue;
                maxV = g;
            }
            int minG = 255;
            for (i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                if (g >= minG) continue;
                minG = g;
            }
            for (i = 0; i < size; ++i) {
                double vP;
                double mP;
                double P = fastBitmap.getGray(i);
                int g = P > (mP = (double)mean.getGray(i)) + this.k * ((Math.sqrt(vP = (double)var.getGray(i)) / (double)maxV - 1.0) * (mP - (double)minG)) ? 255 : 0;
                fastBitmap.setGray(i, g);
            }
        } else {
            throw new IllegalArgumentException("Wolf Threshold only works in grayscale images.");
        }
    }
}

