/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Statistics.Histogram;

public class VerticalIntensityStatistics {
    private Histogram red;
    private Histogram green;
    private Histogram blue;
    private Histogram gray;

    public VerticalIntensityStatistics(FastBitmap fastBitmap) {
        this.ProcessImage(fastBitmap);
    }

    public Histogram getGray() {
        return this.gray;
    }

    public Histogram getRed() {
        return this.red;
    }

    public Histogram getGreen() {
        return this.green;
    }

    public Histogram getBlue() {
        return this.blue;
    }

    private void ProcessImage(FastBitmap fastBitmap) {
        int size = fastBitmap.getSize();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            int[] g = new int[height];
            for (int x = 0; x < size; ++x) {
                int n = x;
                g[n] = g[n] + fastBitmap.getGray(x);
            }
            this.gray = new Histogram(g);
        }
        if (fastBitmap.isRGB()) {
            int[] r = new int[height];
            int[] g = new int[height];
            int[] b = new int[height];
            for (int x = 0; x < height; ++x) {
                int n = x;
                r[n] = r[n] + fastBitmap.getRed(x);
                int n2 = x;
                g[n2] = g[n2] + fastBitmap.getGreen(x);
                int n3 = x;
                b[n3] = b[n3] + fastBitmap.getBlue(x);
            }
            this.red = new Histogram(r);
            this.green = new Histogram(g);
            this.blue = new Histogram(b);
        }
    }
}

