/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Threshold;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;

public class TsaiThreshold
implements IApplyInPlace {
    private boolean invert;

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public TsaiThreshold() {
        this(false);
    }

    public TsaiThreshold(boolean invert) {
        this.invert = invert;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Tsai threshold only works in grayscale images.");
        }
        int value = this.CalculateThreshold(fastBitmap);
        Threshold t = new Threshold(value, this.invert);
        t.applyInPlace(fastBitmap);
    }

    public int CalculateThreshold(FastBitmap fastBitmap) {
        ImageStatistics stat = new ImageStatistics(fastBitmap);
        double[] hist = stat.getHistogramGray().Normalize();
        double m1 = 0.0;
        double m2 = 0.0;
        double m3 = 0.0;
        for (int i = 0; i < hist.length; ++i) {
            m1 += (double)i * hist[i];
            m2 += (double)(i * i) * hist[i];
            m3 += (double)(i * i * i) * hist[i];
        }
        double cd = m2 - m1 * m1;
        double c0 = (-m2 * m2 + m1 * m3) / cd;
        double c1 = (-m3 + m2 * m1) / cd;
        double z0 = 0.5 * (-c1 - Math.sqrt(c1 * c1 - 4.0 * c0));
        double z1 = 0.5 * (-c1 + Math.sqrt(c1 * c1 - 4.0 * c0));
        double p0 = (z1 - m1) / (z1 - z0);
        double sum = 0.0;
        for (int i = 0; i < hist.length; ++i) {
            if (!((sum += hist[i]) > p0)) continue;
            return i;
        }
        return 255;
    }
}

