/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Threshold
implements IApplyInPlace {
    private int value = 128;
    private boolean invert = false;

    public Threshold() {
    }

    public Threshold(int value) {
        this.value = value;
    }

    public Threshold(int value, boolean invert) {
        this.value = value;
        this.invert = invert;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Threshold works only with Grayscale images.");
        }
        int size = fastBitmap.getSize();
        for (int i = 0; i < size; ++i) {
            int g = fastBitmap.getGray(i);
            if (!this.invert) {
                if (g >= this.value) {
                    fastBitmap.setGray(i, 255);
                    continue;
                }
                fastBitmap.setGray(i, 0);
                continue;
            }
            if (g >= this.value) {
                fastBitmap.setGray(i, 0);
                continue;
            }
            fastBitmap.setGray(i, 255);
        }
    }
}

