/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class StereoAnaglyph
implements IApplyInPlace {
    private FastBitmap overlayImage;
    private Algorithm algorithm;

    public StereoAnaglyph() {
    }

    public StereoAnaglyph(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    public StereoAnaglyph(FastBitmap overlayImage, Algorithm algorithm) {
        this.overlayImage = overlayImage;
        this.algorithm = algorithm;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public FastBitmap getOverlayImage() {
        return this.overlayImage;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        int size = sourceImage.getSize();
        switch (this.algorithm) {
            case TrueAnaglyph: {
                for (int i = 0; i < size; ++i) {
                    int r = (int)((double)sourceImage.getRed(i) * 0.299 + (double)sourceImage.getGreen(i) * 0.587 + (double)sourceImage.getBlue(i) * 0.114);
                    int g = 0;
                    int b = (int)((double)this.overlayImage.getRed(i) * 0.299 + (double)this.overlayImage.getGreen(i) * 0.587 + (double)this.overlayImage.getBlue(i) * 0.114);
                    sourceImage.setRGB(i, r, g, b);
                }
                break;
            }
            case GrayAnaglyph: {
                for (int i = 0; i < size; ++i) {
                    int g;
                    int r = (int)((double)sourceImage.getRed(i) * 0.299 + (double)sourceImage.getGreen(i) * 0.587 + (double)sourceImage.getBlue(i) * 0.114);
                    int b = g = (int)((double)this.overlayImage.getRed(i) * 0.299 + (double)this.overlayImage.getGreen(i) * 0.587 + (double)this.overlayImage.getBlue(i) * 0.114);
                    sourceImage.setRGB(i, r, g, b);
                }
                break;
            }
            case ColorAnaglyph: {
                for (int i = 0; i < size; ++i) {
                    int g = this.overlayImage.getGreen(i);
                    int b = this.overlayImage.getBlue(i);
                    sourceImage.setGreen(i, g);
                    sourceImage.setBlue(i, b);
                }
                break;
            }
            case HalfColorAnaglyph: {
                for (int i = 0; i < size; ++i) {
                    int r = (int)((double)sourceImage.getRed(i) * 0.299 + (double)sourceImage.getGreen(i) * 0.587 + (double)sourceImage.getBlue(i) * 0.114);
                    int g = this.overlayImage.getGreen(i);
                    int b = this.overlayImage.getBlue(i);
                    sourceImage.setRGB(i, r, g, b);
                }
                break;
            }
            case OptimizedAnaglyph: {
                for (int i = 0; i < size; ++i) {
                    int r = (int)((double)sourceImage.getGreen(i) * 0.7 + (double)sourceImage.getBlue(i) * 0.3);
                    int g = this.overlayImage.getGreen(i);
                    int b = this.overlayImage.getBlue(i);
                    sourceImage.setRGB(i, r, g, b);
                }
                break;
            }
        }
    }

    public static enum Algorithm {
        TrueAnaglyph,
        GrayAnaglyph,
        ColorAnaglyph,
        HalfColorAnaglyph,
        OptimizedAnaglyph;

    }
}

