/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Crop;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class Shrink
implements IApply,
IApplyInPlace {
    private boolean isBlackObject = false;

    public Shrink() {
    }

    public Shrink(boolean isBlackObject) {
        this.isBlackObject = isBlackObject;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int height;
            int gray = 255;
            if (this.isBlackObject) {
                gray = 0;
            }
            int width = fastBitmap.getWidth();
            int minHeight = height = fastBitmap.getHeight();
            int maxHeight = 0;
            int minWidth = width;
            int maxWidth = 0;
            int index = 0;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    if (fastBitmap.getGray(index++) != gray) continue;
                    if (i < minHeight) {
                        minHeight = i;
                    }
                    if (i > maxHeight) {
                        maxHeight = i;
                    }
                    if (j < minWidth) {
                        minWidth = j;
                    }
                    if (j <= maxWidth) continue;
                    maxWidth = j;
                }
            }
            if (minHeight == height && minWidth == width && maxHeight == 0 && maxWidth == 0) {
                minWidth = 0;
                minHeight = 0;
            }
            Crop crop = new Crop(minHeight, minWidth, maxWidth - minWidth + 1, maxHeight - minHeight + 1);
            return crop.apply(fastBitmap);
        }
        if (fastBitmap.isRGB()) {
            int height;
            int width = fastBitmap.getWidth();
            int minHeight = height = fastBitmap.getHeight();
            int maxHeight = 0;
            int minWidth = width;
            int maxWidth = 0;
            int index = 0;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    if (fastBitmap.getRed(index) != 0 && fastBitmap.getGreen(index) != 0 && fastBitmap.getBlue(index) != 0) {
                        if (i < minHeight) {
                            minHeight = i;
                        }
                        if (i > maxHeight) {
                            maxHeight = i;
                        }
                        if (j < minWidth) {
                            minWidth = j;
                        }
                        if (j > maxWidth) {
                            maxWidth = j;
                        }
                    }
                    ++index;
                }
            }
            Crop crop = new Crop(minHeight, minWidth, maxWidth - minWidth + 1, maxHeight - minHeight + 1);
            return crop.apply(fastBitmap);
        }
        return null;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }
}

