/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class RobertsCrossEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap image;
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            image = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
            for (int i = 1; i < height - 1; ++i) {
                for (int j = 1; j < width - 1; ++j) {
                    int p1 = fastBitmap.getGray(i - 1, j - 1);
                    int p2 = fastBitmap.getGray(i - 1, j);
                    int p3 = fastBitmap.getGray(i, j - 1);
                    int p4 = fastBitmap.getGray(i, j);
                    int g = Math.abs(p1 - p4) + Math.abs(p2 - p3);
                    image.setGray(i, j, g);
                }
            }
        } else {
            throw new IllegalArgumentException("Roberts Cross Edge Detector only works with grayscale images.");
        }
        fastBitmap.setImage(image);
    }
}

