/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class ResizeNearestNeighbor
implements IApply,
IApplyInPlace {
    private int newWidth;
    private int newHeight;

    public int getNewWidth() {
        return this.newWidth;
    }

    public void setNewWidth(int newWidth) {
        this.newWidth = newWidth;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public void setNewHeight(int newHeight) {
        this.newHeight = newHeight;
    }

    public void setNewSize(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    public ResizeNearestNeighbor(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        FastBitmap dest = new FastBitmap(this.newWidth, this.newHeight, fastBitmap.getColorSpace());
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double jFactor = (double)width / (double)this.newWidth;
        double iFactor = (double)height / (double)this.newHeight;
        if (fastBitmap.isGrayscale()) {
            for (int i = 0; i < this.newHeight; ++i) {
                int I = (int)((double)i * iFactor);
                for (int j = 0; j < this.newWidth; ++j) {
                    int J = (int)((double)j * jFactor);
                    int p = fastBitmap.getGray(I, J);
                    dest.setGray(i, j, p);
                }
            }
            return dest;
        }
        for (int i = 0; i < this.newHeight; ++i) {
            int I = (int)((double)i * iFactor);
            for (int j = 0; j < this.newWidth; ++j) {
                int J = (int)((double)j * jFactor);
                int r = fastBitmap.getRed(I, J);
                int g = fastBitmap.getGreen(I, J);
                int b = fastBitmap.getBlue(I, J);
                dest.setRGB(i, j, r, g, b);
            }
        }
        return dest;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }
}

