/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ReplaceRGBChannel
implements IApplyInPlace {
    private FastBitmap band;
    private RGB rgb;

    public FastBitmap getBand() {
        return this.band;
    }

    public void setBand(FastBitmap band) {
        this.band = band;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public ReplaceRGBChannel(FastBitmap fastBitmap, RGB rgb) {
        this.band = fastBitmap;
        this.rgb = rgb;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!this.band.isGrayscale() || !fastBitmap.isRGB()) {
            try {
                throw new Exception("ReplaceRGBChannel needs one image grayscale and another RGB image");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.band.getWidth() != fastBitmap.getWidth() || this.band.getHeight() != fastBitmap.getHeight()) {
            try {
                throw new Exception("The image must be the same dimension");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        switch (this.rgb) {
            case R: {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        fastBitmap.setRed(x, y, this.band.getGray(x, y));
                    }
                }
                break;
            }
            case G: {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        fastBitmap.setGreen(x, y, this.band.getGray(x, y));
                    }
                }
                break;
            }
            case B: {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        fastBitmap.setBlue(x, y, this.band.getGray(x, y));
                    }
                }
                break;
            }
        }
    }

    public static enum RGB {
        R,
        G,
        B;

    }
}

