/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Tools.ImageUtils;
import Catalano.Math.Functions.Gaussian;
import Catalano.Math.Matrix;
import Catalano.Math.PaddingMatrix;

public class SelfQuocientImage
implements IPhotometricFilter {
    private int size;
    private double sigma;
    private double[][] kernel;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
        this.BuildKernel();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.BuildKernel();
    }

    public SelfQuocientImage() {
        this(5);
    }

    public SelfQuocientImage(int size) {
        this(size, 1.0);
    }

    public SelfQuocientImage(int size, double sigma) {
        this.size = size;
        this.sigma = sigma;
        this.BuildKernel();
    }

    private void BuildKernel() {
        Gaussian g = new Gaussian(this.sigma);
        this.kernel = g.Kernel2D(this.size);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Self Quocient Image only works in grayscale images.");
        }
        double[][] image = fastBitmap.toMatrixGrayAsDouble();
        double[][] result = this.Process(image, true);
        fastBitmap.matrixToImage(result);
    }

    public double[][] Process(double[][] image, boolean normalize) {
        int j;
        int i;
        int width = image[0].length;
        int height = image.length;
        ImageUtils.Normalize(image);
        int padSize = (int)Math.floor((double)this.size / 2.0);
        PaddingMatrix pad = new PaddingMatrix(padSize, padSize, true);
        double[][] padX = pad.Create(image);
        double[][] Z = new double[height][width];
        for (i = padSize; i < height + padSize; ++i) {
            for (j = padSize; j < width + padSize; ++j) {
                double[][] region = Matrix.Submatrix(padX, i - padSize, i + padSize, j - padSize, j + padSize);
                double[][] m = this.returnStep(region);
                double[][] filt1 = Matrix.DotProduct(this.kernel, m);
                double sum = 0.0;
                for (int k = 0; k < this.size; ++k) {
                    for (int l = 0; l < this.size; ++l) {
                        sum += filt1[k][l];
                    }
                }
                Matrix.Divide(filt1, sum);
                Z[i - padSize][j - padSize] = Matrix.Sum(Matrix.DotProduct(filt1, region)) / (double)(this.size * this.size);
            }
        }
        for (i = 0; i < Z.length; ++i) {
            for (j = 0; j < Z[0].length; ++j) {
                Z[i][j] = image[i][j] / (Z[i][j] + 0.01);
            }
        }
        if (normalize) {
            ImageUtils.Normalize(Z);
        }
        return Z;
    }

    private double[][] returnStep(double[][] region) {
        double[][] m = new double[region.length][region[0].length];
        double mean = Matrix.Mean(region);
        for (int i = 0; i < region.length; ++i) {
            for (int j = 0; j < region[0].length; ++j) {
                m[i][j] = region[i][j] >= mean ? 1.0 : 0.0;
            }
        }
        return m;
    }
}

