/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.HistogramAdjust;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Tools.ImageUtils;
import Catalano.Imaging.Tools.Kernel;
import Catalano.Math.Functions.Gaussian;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;

public class DifferenceOfGaussian
implements IPhotometricFilter {
    private double sigma1;
    private double sigma2;
    private double[][] gv1;
    private double[][] gv2;

    public double getSigma1() {
        return this.sigma1;
    }

    public void setSigma1(double sigma1) {
        this.sigma1 = sigma1;
        this.BuildKernels();
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public void setSigma2(double sigma2) {
        this.sigma2 = sigma2;
        this.BuildKernels();
    }

    public DifferenceOfGaussian() {
        this(1.0, 2.0);
    }

    public DifferenceOfGaussian(double sigma1, double sigma2) {
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.BuildKernels();
    }

    private void BuildKernels() {
        int size1 = 2 * (int)Math.ceil(3.0 * this.sigma1) + 1;
        Gaussian ga = new Gaussian(this.sigma1);
        double[][] g1 = ga.Kernel2D(size1);
        int size2 = 2 * (int)Math.ceil(3.0 * this.sigma2) + 1;
        ga.setSigma(this.sigma2);
        double[][] g2 = ga.Kernel2D(size2);
        this.gv1 = Kernel.Decompose(g1);
        this.gv2 = Kernel.Decompose(g2);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int j;
            int i;
            double[][] image = fastBitmap.toMatrixGrayAsDouble();
            ImageUtils.Normalize(image);
            double[][] im1 = ImageUtils.Convolution(image, this.gv1[0], this.gv1[1], true);
            double[][] im2 = ImageUtils.Convolution(image, this.gv2[0], this.gv2[1], true);
            im1 = Matrix.Subtract(im1, im2);
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (i = 0; i < im1.length; ++i) {
                for (j = 0; j < im1[0].length; ++j) {
                    min = Math.min(min, im1[i][j]);
                    max = Math.max(max, im1[i][j]);
                }
            }
            for (i = 0; i < im1.length; ++i) {
                for (j = 0; j < im1[0].length; ++j) {
                    fastBitmap.setGray(i, j, (int)Tools.Scale(min, max, 0.0, 255.0, im1[i][j]));
                }
            }
        } else if (fastBitmap.isRGB()) {
            int j;
            int i;
            double[][][] image = fastBitmap.toMatrixRGBAsDouble();
            double[][][] im1 = ImageUtils.Convolution(image, this.gv1[0], this.gv1[1], true);
            double[][][] im2 = ImageUtils.Convolution(image, this.gv2[0], this.gv2[1], true);
            for (int i2 = 0; i2 < im1.length; ++i2) {
                for (int j2 = 0; j2 < im1[0].length; ++j2) {
                    im1[i2][j2][0] = im1[i2][j2][0] - im2[i2][j2][0];
                    im1[i2][j2][1] = im1[i2][j2][1] - im2[i2][j2][1];
                    im1[i2][j2][2] = im1[i2][j2][2] - im2[i2][j2][2];
                }
            }
            double minB = Double.MAX_VALUE;
            double minG = Double.MAX_VALUE;
            double minR = Double.MAX_VALUE;
            double maxB = -1.7976931348623157E308;
            double maxG = -1.7976931348623157E308;
            double maxR = -1.7976931348623157E308;
            for (i = 0; i < im1.length; ++i) {
                for (j = 0; j < im1[0].length; ++j) {
                    minR = Math.min(minR, im1[i][j][0]);
                    minG = Math.min(minG, im1[i][j][1]);
                    minB = Math.min(minB, im1[i][j][2]);
                    maxR = Math.max(maxR, im1[i][j][0]);
                    maxG = Math.max(maxG, im1[i][j][1]);
                    maxB = Math.max(maxB, im1[i][j][2]);
                }
            }
            for (i = 0; i < im1.length; ++i) {
                for (j = 0; j < im1[0].length; ++j) {
                    int r = (int)Tools.Scale(minR, maxR, 0.0, 255.0, im1[i][j][0]);
                    int g = (int)Tools.Scale(minG, maxG, 0.0, 255.0, im1[i][j][1]);
                    int b = (int)Tools.Scale(minB, maxB, 0.0, 255.0, im1[i][j][2]);
                    fastBitmap.setRGB(i, j, r, g, b);
                }
            }
            HistogramAdjust ha = new HistogramAdjust();
            ha.applyInPlace(fastBitmap);
        }
    }

    public double[][] Process(double[][] image, boolean normalize) {
        double[][] copy = Matrix.Copy(image);
        ImageUtils.Normalize(copy);
        double[][] im1 = ImageUtils.Convolution(copy, this.gv1[0], this.gv1[1]);
        double[][] im2 = ImageUtils.Convolution(copy, this.gv2[0], this.gv2[1]);
        im1 = Matrix.Subtract(im1, im2);
        if (normalize) {
            ImageUtils.Normalize(im1);
        }
        return im1;
    }
}

