/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;

public class PeronaMalikAnisotropicDiffusion
implements IApplyInPlace {
    private int iterations;
    private double kappa;
    private double lambda;
    private Diffusion diffusion;

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public double getKappa() {
        return this.kappa;
    }

    public void setKappa(double kappa) {
        this.kappa = kappa;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public Diffusion getDiffusion() {
        return this.diffusion;
    }

    public void setDiffusion(Diffusion diffusion) {
        this.diffusion = diffusion;
    }

    public PeronaMalikAnisotropicDiffusion() {
        this(20);
    }

    public PeronaMalikAnisotropicDiffusion(int iterations) {
        this(iterations, 10.0, 0.25, Diffusion.HighContrastEdges);
    }

    public PeronaMalikAnisotropicDiffusion(int iterations, double kappa, double lambda, Diffusion diffusion) {
        this.iterations = iterations;
        this.kappa = kappa;
        this.lambda = lambda;
        this.diffusion = diffusion;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            double[][] diff = fastBitmap.toMatrixGrayAsDouble();
            int h = diff.length;
            int w = diff[0].length;
            double[][] deltaN = new double[h][w];
            double[][] deltaS = new double[h][w];
            double[][] deltaE = new double[h][w];
            double[][] deltaW = new double[h][w];
            for (int i = 0; i < this.iterations; ++i) {
                double cW;
                double cE;
                double cS;
                double cN;
                int y;
                int x;
                int y2;
                for (y2 = 0; y2 < w; ++y2) {
                    deltaN[0][y2] = -diff[0][y2];
                }
                for (x = 1; x < h; ++x) {
                    for (y = 0; y < w; ++y) {
                        deltaN[x][y] = diff[x - 1][y] - diff[x][y];
                    }
                }
                for (x = 0; x < h - 1; ++x) {
                    for (y = 0; y < w; ++y) {
                        deltaS[x][y] = diff[x + 1][y] - diff[x][y];
                    }
                }
                for (y2 = 0; y2 < w; ++y2) {
                    deltaS[h - 1][y2] = -diff[h - 1][y2];
                }
                for (x = 0; x < h; ++x) {
                    for (y = 0; y < w - 1; ++y) {
                        deltaE[x][y] = diff[x][y + 1] - diff[x][y];
                    }
                }
                for (x = 0; x < h; ++x) {
                    deltaE[x][w - 1] = -diff[x][w - 1];
                }
                for (x = 0; x < h; ++x) {
                    for (y = 1; y < w; ++y) {
                        deltaW[x][y] = diff[x][y - 1] - diff[x][y];
                    }
                }
                for (x = 0; x < h; ++x) {
                    deltaW[x][0] = -diff[x][0];
                }
                if (this.diffusion == Diffusion.HighContrastEdges) {
                    for (x = 0; x < h; ++x) {
                        for (y = 0; y < w; ++y) {
                            cN = Math.exp(-Math.pow(deltaN[x][y] / this.kappa, 2.0));
                            cS = Math.exp(-Math.pow(deltaS[x][y] / this.kappa, 2.0));
                            cE = Math.exp(-Math.pow(deltaE[x][y] / this.kappa, 2.0));
                            cW = Math.exp(-Math.pow(deltaW[x][y] / this.kappa, 2.0));
                            diff[x][y] = diff[x][y] + this.lambda * (deltaN[x][y] * cN + deltaS[x][y] * cS + deltaE[x][y] * cE + deltaW[x][y] * cW);
                        }
                    }
                    continue;
                }
                for (x = 0; x < h; ++x) {
                    for (y = 0; y < w; ++y) {
                        cN = 1.0 / (1.0 + Math.pow(deltaN[x][y] / this.kappa, 2.0));
                        cS = 1.0 / (1.0 + Math.pow(deltaS[x][y] / this.kappa, 2.0));
                        cE = 1.0 / (1.0 + Math.pow(deltaE[x][y] / this.kappa, 2.0));
                        cW = 1.0 / (1.0 + Math.pow(deltaW[x][y] / this.kappa, 2.0));
                        diff[x][y] = diff[x][y] + this.lambda * (deltaN[x][y] * cN + deltaS[x][y] * cS + deltaE[x][y] * cE + deltaW[x][y] * cW);
                    }
                }
            }
            double min = Matrix.Min(diff);
            double max = Matrix.Max(diff);
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    fastBitmap.setGray(i, j, (int)Tools.Scale(min, max, 0.0, 255.0, diff[i][j]));
                }
            }
        } else {
            throw new IllegalArgumentException("Perona-Malik only works in grayscale images.");
        }
    }

    public static enum Diffusion {
        HighContrastEdges,
        WideRegions;

    }
}

