/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Threshold;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageHistogram;
import Catalano.Imaging.Tools.ImageStatistics;

public class OtsuThreshold
implements IApplyInPlace {
    private boolean invert = false;

    public OtsuThreshold() {
    }

    public OtsuThreshold(boolean invert) {
        this.invert = invert;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int value = this.CalculateThreshold(fastBitmap);
        Threshold t = new Threshold(value, this.invert);
        t.applyInPlace(fastBitmap);
    }

    public int CalculateThreshold(FastBitmap fastBitmap) {
        ImageStatistics stat = new ImageStatistics(fastBitmap);
        ImageHistogram hist = stat.getHistogramGray();
        int[] histogram = hist.getValues();
        int total = fastBitmap.getWidth() * fastBitmap.getHeight();
        double sum = 0.0;
        for (int i = 0; i < 256; ++i) {
            sum += (double)(i * histogram[i]);
        }
        double sumB = 0.0;
        int wB = 0;
        int wF = 0;
        double varMax = 0.0;
        int threshold = 0;
        for (int i = 0; i < 256; ++i) {
            double mF;
            double varBetween;
            if ((wB += histogram[i]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            double mB = (sumB += (double)(i * histogram[i])) / (double)wB;
            if (!((varBetween = (double)wB * (double)wF * (mB - (mF = (sum - sumB) / (double)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }
}

