/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Integral.IntegralMean;
import Catalano.Imaging.Filters.Integral.IntegralVariance;
import Catalano.Imaging.IApplyInPlace;

public class NickThreshold
implements IApplyInPlace {
    private int radius = 15;
    private double k = -0.2;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public NickThreshold() {
    }

    public NickThreshold(int radius) {
        this.radius = radius;
    }

    public NickThreshold(int radius, double k) {
        this.radius = radius;
        this.k = k;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            FastBitmap mean = new FastBitmap(fastBitmap);
            FastBitmap var = new FastBitmap(fastBitmap);
            IntegralMean im = new IntegralMean(this.radius);
            im.applyInPlace(mean);
            IntegralVariance iv = new IntegralVariance(this.radius);
            iv.applyInPlace(var);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                float vP;
                float mP;
                float P = fastBitmap.getGray(i);
                int g = (double)P > (double)(mP = (float)mean.getGray(i)) + this.k * Math.sqrt((vP = (float)var.getGray(i)) + mP * mP) ? 255 : 0;
                fastBitmap.setGray(i, g);
            }
        } else {
            throw new IllegalArgumentException("Nick Threshold only works in grayscale images.");
        }
    }
}

