/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Nand
implements IApplyInPlace {
    FastBitmap overlayImage;

    public Nand() {
    }

    public Nand(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        int sizeOrigin = width * height;
        int sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
        if (sourceImage.isGrayscale() && this.overlayImage.isGrayscale() && sizeOrigin == sizeDestination) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int grayS = sourceImage.getGray(x, y);
                    int grayO = this.overlayImage.getGray(x, y);
                    if (grayS == 255 && grayO == 255) {
                        sourceImage.setGray(x, y, 0);
                        continue;
                    }
                    sourceImage.setGray(x, y, 255);
                }
            }
        }
    }
}

