/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class MoveTowards
implements IApplyInPlace {
    private FastBitmap overlayImage;
    private int stepSize = 1;

    public MoveTowards() {
    }

    public MoveTowards(FastBitmap overlayImage, int stepSize) {
        this.overlayImage = overlayImage;
        this.setStepSize(stepSize);
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize = stepSize < 0 ? 1 : stepSize;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        block13: {
            int sizeDestination;
            int size;
            block12: {
                size = sourceImage.getSize();
                sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
                if (!sourceImage.isGrayscale() || !this.overlayImage.isGrayscale()) break block12;
                if (size != sizeDestination) break block13;
                for (int i = 0; i < size; ++i) {
                    int v = this.overlayImage.getGray(i) - sourceImage.getGray(i);
                    int l = sourceImage.getGray(i);
                    if (v > 0) {
                        l += this.stepSize < v ? this.stepSize : v;
                    } else if (v < 0) {
                        l -= this.stepSize < (v = -v) ? this.stepSize : v;
                    }
                    sourceImage.setGray(i, l);
                }
                break block13;
            }
            if (sourceImage.isRGB() && this.overlayImage.isRGB() && size == sizeDestination) {
                for (int i = 0; i < size; ++i) {
                    int r = this.overlayImage.getRed(i) - sourceImage.getRed(i);
                    int g = this.overlayImage.getGreen(i) - sourceImage.getGreen(i);
                    int b = this.overlayImage.getBlue(i) - sourceImage.getBlue(i);
                    int vR = sourceImage.getRed(i);
                    int vG = sourceImage.getGreen(i);
                    int vB = sourceImage.getBlue(i);
                    if (r > 0) {
                        vR += this.stepSize < r ? this.stepSize : r;
                    }
                    if (g > 0) {
                        vG += this.stepSize < g ? this.stepSize : g;
                    }
                    if (b > 0) {
                        vB += this.stepSize < b ? this.stepSize : b;
                    }
                    if (r < 0) {
                        vR -= this.stepSize < (r = -r) ? this.stepSize : r;
                    }
                    if (g < 0) {
                        vG -= this.stepSize < (g = -g) ? this.stepSize : g;
                    }
                    if (b < 0) {
                        vB -= this.stepSize < (b = -b) ? this.stepSize : b;
                    }
                    sourceImage.setRGB(i, vR, vG, vB);
                }
            }
        }
    }
}

