/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Morph
implements IApplyInPlace {
    private FastBitmap overlayImage;
    private double sourcePercent = 0.5;

    public Morph() {
    }

    public Morph(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    public double getSourcePercent() {
        return this.sourcePercent;
    }

    public void setSourcePercent(double sourcePercent) {
        sourcePercent = sourcePercent < 0.0 ? 0.0 : sourcePercent;
        this.sourcePercent = sourcePercent = sourcePercent > 1.0 ? 1.0 : sourcePercent;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        block4: {
            int sizeDestination;
            int size;
            block3: {
                size = sourceImage.getSize();
                sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
                if (!sourceImage.isGrayscale() || !this.overlayImage.isGrayscale()) break block3;
                if (size != sizeDestination) break block4;
                double q = 1.0 - this.sourcePercent;
                for (int i = 0; i < size; ++i) {
                    int lS = sourceImage.getGray(i);
                    int lO = this.overlayImage.getGray(i);
                    sourceImage.setGray(i, (int)(this.sourcePercent * (double)lS + q * (double)lO));
                }
                break block4;
            }
            if (sourceImage.isRGB() && this.overlayImage.isRGB() && size == sizeDestination) {
                double q = 1.0 - this.sourcePercent;
                for (int i = 0; i < size; ++i) {
                    int rS = sourceImage.getRed(i);
                    int gS = sourceImage.getGreen(i);
                    int bS = sourceImage.getBlue(i);
                    int rO = this.overlayImage.getRed(i);
                    int gO = this.overlayImage.getGreen(i);
                    int bO = this.overlayImage.getBlue(i);
                    int r = (int)(this.sourcePercent * (double)rS + q * (double)rO);
                    int g = (int)(this.sourcePercent * (double)gS + q * (double)gO);
                    int b = (int)(this.sourcePercent * (double)bS + q * (double)bO);
                    sourceImage.setRGB(i, r, g, b);
                }
            }
        }
    }
}

