/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ModifiedWhitePatch
implements IApplyInPlace {
    private int redThreshold = 128;
    private int greenThreshold = 128;
    private int blueThreshold = 128;

    public void setThreshold(int threshold) {
        this.redThreshold = threshold;
        this.greenThreshold = threshold;
        this.blueThreshold = threshold;
    }

    public int getRedThreshold() {
        return this.redThreshold;
    }

    public void setRedThreshold(int redThreshold) {
        this.redThreshold = redThreshold;
    }

    public int getGreenThreshold() {
        return this.greenThreshold;
    }

    public void setGreenThreshold(int greenThreshold) {
        this.greenThreshold = greenThreshold;
    }

    public int getBlueThreshold() {
        return this.blueThreshold;
    }

    public void setBlueThreshold(int blueThreshold) {
        this.blueThreshold = blueThreshold;
    }

    public ModifiedWhitePatch() {
        this(128);
    }

    public ModifiedWhitePatch(int threshold) {
        this(threshold, threshold, threshold);
    }

    public ModifiedWhitePatch(int redThreshold, int greenThreshold, int blueThreshold) {
        this.redThreshold = redThreshold;
        this.greenThreshold = greenThreshold;
        this.blueThreshold = blueThreshold;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int i;
            int size = fastBitmap.getSize();
            double kr = 0.0;
            double kg = 0.0;
            double kb = 0.0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (i = 0; i < size; ++i) {
                if (fastBitmap.getRed(i) > this.redThreshold) {
                    kr += (double)fastBitmap.getRed(i);
                    ++tr;
                }
                if (fastBitmap.getGreen(i) > this.greenThreshold) {
                    kg += (double)fastBitmap.getGreen(i);
                    ++tg;
                }
                if (fastBitmap.getBlue(i) <= this.blueThreshold) continue;
                kb += (double)fastBitmap.getBlue(i);
                ++tb;
            }
            kr = 255.0 / (kr / (double)tr);
            kg = 255.0 / (kg / (double)tg);
            kb = 255.0 / (kb / (double)tb);
            for (i = 0; i < size; ++i) {
                double r = kr * (double)fastBitmap.getRed(i);
                double g = kg * (double)fastBitmap.getGreen(i);
                double b = kb * (double)fastBitmap.getBlue(i);
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                fastBitmap.setRGB(i, (int)r, (int)g, (int)b);
            }
        } else {
            throw new IllegalArgumentException("Modified White Patch only works in RGB images.");
        }
    }
}

