/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Mirror
implements IApplyInPlace {
    private boolean mirrorX;
    private boolean mirrorY;

    public Mirror(boolean MirrorX, boolean MirrorY) {
        this.mirrorX = MirrorX;
        this.mirrorY = MirrorY;
    }

    public void setMirrorX(boolean mirrorX) {
        this.mirrorX = mirrorX;
    }

    public void setMirrorY(boolean mirrorY) {
        this.mirrorY = mirrorY;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block13: {
            int halfHeight;
            int halfWidth;
            int height;
            int width;
            block12: {
                int b;
                int g;
                int r;
                int tBlue;
                int tGreen;
                int tRed;
                int y;
                int x;
                width = fastBitmap.getWidth();
                height = fastBitmap.getHeight();
                halfWidth = width / 2;
                halfHeight = height / 2;
                if (!fastBitmap.isRGB()) break block12;
                if (this.mirrorX) {
                    for (x = 0; x < height; ++x) {
                        int w = width - 1;
                        for (y = 0; y < halfWidth; ++y) {
                            tRed = fastBitmap.getRed(x, w);
                            tGreen = fastBitmap.getGreen(x, w);
                            tBlue = fastBitmap.getBlue(x, w);
                            r = fastBitmap.getRed(x, y);
                            g = fastBitmap.getGreen(x, y);
                            b = fastBitmap.getBlue(x, y);
                            fastBitmap.setRGB(x, y, tRed, tGreen, tBlue);
                            fastBitmap.setRGB(x, w, r, g, b);
                            --w;
                        }
                    }
                }
                if (!this.mirrorY) break block13;
                for (x = 0; x < halfHeight; ++x) {
                    int h = height - x - 1;
                    for (y = 0; y < width; ++y) {
                        tRed = fastBitmap.getRed(h, y);
                        tGreen = fastBitmap.getGreen(h, y);
                        tBlue = fastBitmap.getBlue(h, y);
                        r = fastBitmap.getRed(x, y);
                        g = fastBitmap.getGreen(x, y);
                        b = fastBitmap.getBlue(x, y);
                        fastBitmap.setRGB(x, y, tRed, tGreen, tBlue);
                        fastBitmap.setRGB(h, y, r, g, b);
                    }
                }
                break block13;
            }
            if (fastBitmap.isGrayscale()) {
                int g;
                int tG;
                int y;
                int x;
                if (this.mirrorX) {
                    for (x = 0; x < height; ++x) {
                        int w = width - 1;
                        for (y = 0; y < halfWidth; ++y) {
                            tG = fastBitmap.getGray(x, w);
                            g = fastBitmap.getGray(x, y);
                            fastBitmap.setGray(x, y, tG);
                            fastBitmap.setGray(x, w, g);
                            --w;
                        }
                    }
                }
                if (this.mirrorY) {
                    for (x = 0; x < halfHeight; ++x) {
                        int h = height - x - 1;
                        for (y = 0; y < width; ++y) {
                            tG = fastBitmap.getGray(h, y);
                            g = fastBitmap.getGray(x, y);
                            fastBitmap.setGray(x, y, tG);
                            fastBitmap.setGray(h, y, g);
                        }
                    }
                }
            }
        }
    }
}

