/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class MidPoint
implements IApplyInPlace {
    private int radius = 1;

    public MidPoint() {
    }

    public MidPoint(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        FastBitmap copy = new FastBitmap(fastBitmap);
        int lines = this.CalcLines(this.radius);
        if (fastBitmap.isGrayscale()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int max = 0;
                    int min = 255;
                    for (int i = 0; i < lines; ++i) {
                        int Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            max = Math.max(max, copy.getGray(Xline, Yline));
                            min = Math.min(min, copy.getGray(Xline, Yline));
                        }
                    }
                    int gray = (max + min) / 2;
                    fastBitmap.setGray(x, y, gray);
                }
            }
        } else {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int maxB = 0;
                    int maxG = 0;
                    int maxR = 0;
                    int minB = 255;
                    int minG = 255;
                    int minR = 255;
                    for (int i = 0; i < lines; ++i) {
                        int Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            maxR = Math.max(maxR, copy.getRed(Xline, Yline));
                            maxG = Math.max(maxG, copy.getGreen(Xline, Yline));
                            maxB = Math.max(maxB, copy.getBlue(Xline, Yline));
                            minR = Math.min(minR, copy.getRed(Xline, Yline));
                            minG = Math.min(minG, copy.getGreen(Xline, Yline));
                            minB = Math.min(minB, copy.getBlue(Xline, Yline));
                        }
                    }
                    int r = (maxR + minR) / 2;
                    int g = (maxG + minG) / 2;
                    int b = (maxB + minB) / 2;
                    fastBitmap.setRGB(x, y, r, g, b);
                }
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

