/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Merge
implements IApplyInPlace {
    private FastBitmap overlayImage;

    public Merge() {
    }

    public Merge(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        block6: {
            int sizeDestination;
            int size;
            block5: {
                size = sourceImage.getSize();
                sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
                if (!sourceImage.isGrayscale() || !this.overlayImage.isGrayscale()) break block5;
                if (size != sizeDestination) break block6;
                for (int i = 0; i < size; ++i) {
                    int l = this.overlayImage.getGray(i);
                    if (l <= sourceImage.getGray(i)) continue;
                    sourceImage.setGray(i, l);
                }
                break block6;
            }
            if (sourceImage.isRGB() && this.overlayImage.isRGB() && size == sizeDestination) {
                for (int i = 0; i < size; ++i) {
                    int r = this.overlayImage.getRed(i);
                    int g = this.overlayImage.getGreen(i);
                    int b = this.overlayImage.getBlue(i);
                    if (r > sourceImage.getRed(i)) {
                        sourceImage.setRed(i, r);
                    }
                    if (g > sourceImage.getGreen(i)) {
                        sourceImage.setGreen(i, g);
                    }
                    if (b <= sourceImage.getBlue(i)) continue;
                    sourceImage.setBlue(i, b);
                }
            }
        }
    }
}

