/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class MedianCut
implements IApplyInPlace {
    private static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private Cube[] list;
    private int nCubes = 8;
    private byte[] rLUT;
    private byte[] gLUT;
    private byte[] bLUT;

    public int getNumberOfCubes() {
        return this.nCubes;
    }

    public void setNumberOfCubes(int nCubes) {
        this.nCubes = Math.max(1, Math.min(nCubes, 256));
    }

    public MedianCut() {
    }

    public MedianCut(int nCubes) {
        this.setNumberOfCubes(nCubes);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap copy;
        if (fastBitmap.isRGB()) {
            int i;
            copy = new FastBitmap(fastBitmap.getWidth(), fastBitmap.getHeight());
            int[] pixels = fastBitmap.getRGBData();
            this.hist = new int[32768];
            for (int i2 = 0; i2 < pixels.length; ++i2) {
                int color16;
                int n = color16 = this.rgb(pixels[i2]);
                this.hist[n] = this.hist[n] + 1;
            }
            int longdim = 0;
            this.list = new Cube[256];
            this.histPtr = new int[32768];
            int ncubes = 0;
            Cube cube = new Cube();
            int color = 0;
            for (i = 0; i <= Short.MAX_VALUE; ++i) {
                if (this.hist[i] == 0) continue;
                this.histPtr[color++] = i;
                cube.count += this.hist[i];
            }
            cube.lower = 0;
            cube.upper = color - 1;
            cube.level = 0;
            this.Shrink(cube);
            this.list[ncubes++] = cube;
            while (ncubes < this.nCubes) {
                int level = 255;
                int splitpos = -1;
                for (int k = 0; k <= ncubes - 1; ++k) {
                    if (this.list[k].lower == this.list[k].upper || this.list[k].level >= level) continue;
                    level = this.list[k].level;
                    splitpos = k;
                }
                if (splitpos == -1) break;
                cube = this.list[splitpos];
                int lr = cube.rmax - cube.rmin;
                int lg = cube.gmax - cube.gmin;
                int lb = cube.bmax - cube.bmin;
                if (lr >= lg && lr >= lb) {
                    longdim = 0;
                }
                if (lg >= lr && lg >= lb) {
                    longdim = 1;
                }
                if (lb >= lr && lb >= lg) {
                    longdim = 2;
                }
                this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
                this.quickSort(this.histPtr, cube.lower, cube.upper);
                this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
                int count = 0;
                for (i = cube.lower; i <= cube.upper - 1 && count < cube.count / 2; count += this.hist[color], ++i) {
                    color = this.histPtr[i];
                }
                int median = i;
                Cube cubeA = new Cube();
                cubeA.lower = cube.lower;
                cubeA.upper = median - 1;
                cubeA.count = count;
                cubeA.level = cube.level + 1;
                this.Shrink(cubeA);
                this.list[splitpos] = cubeA;
                Cube cubeB = new Cube();
                cubeB.lower = median;
                cubeB.upper = cube.upper;
                cubeB.count = cube.count - count;
                cubeB.level = cube.level + 1;
                this.Shrink(cubeB);
                this.list[ncubes++] = cubeB;
            }
            this.makeInverseMap(this.hist, ncubes);
            int[] temp = copy.getRGBData();
            for (int p = 0; p < pixels.length; ++p) {
                int color16 = this.rgb(pixels[p]);
                int r = this.rLUT[this.hist[color16]] & 0xFF;
                int g = this.gLUT[this.hist[color16]] & 0xFF;
                int b = this.bLUT[this.hist[color16]] & 0xFF;
                temp[p] = r << 16 | g << 8 | b;
            }
        } else {
            throw new IllegalArgumentException("Median cut only works in RGB images.");
        }
        fastBitmap.setImage(copy);
    }

    private final int rgb(int c) {
        int r = (c & 0xF80000) >> 19;
        int g = (c & 0xF800) >> 6;
        int b = (c & 0xF8) << 7;
        return r | g | b;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    private void Shrink(Cube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int color = this.histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b > bmax) {
                bmax = b;
            }
            if (b >= bmin) continue;
            bmin = b;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.bmin = bmin;
        cube.bmax = bmax;
    }

    private void makeInverseMap(int[] hist, int ncubes) {
        int color;
        int i;
        Cube cube;
        int k;
        this.rLUT = new byte[256];
        this.gLUT = new byte[256];
        this.bLUT = new byte[256];
        for (k = 0; k <= ncubes - 1; ++k) {
            int b;
            int g;
            int r;
            cube = this.list[k];
            float bsum = 0.0f;
            float gsum = 0.0f;
            float rsum = 0.0f;
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.histPtr[i];
                r = this.red(color);
                rsum += (float)r * (float)hist[color];
                g = this.green(color);
                gsum += (float)g * (float)hist[color];
                b = this.blue(color);
                bsum += (float)b * (float)hist[color];
            }
            r = (int)(rsum / (float)cube.count);
            g = (int)(gsum / (float)cube.count);
            b = (int)(bsum / (float)cube.count);
            if (r == 248 && g == 248 && b == 248) {
                b = 255;
                g = 255;
                r = 255;
            }
            this.rLUT[k] = (byte)r;
            this.gLUT[k] = (byte)g;
            this.bLUT[k] = (byte)b;
        }
        for (k = 0; k <= ncubes - 1; ++k) {
            cube = this.list[k];
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.histPtr[i];
                hist[color] = k;
            }
        }
    }

    private void reorderColors(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    a[i] = r << 10 | c >> 5;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 5 & 0x1F;
                    int b = c >> 10;
                    a[i] = g << 10 | b << 5 | r;
                }
                break;
            }
        }
    }

    private void restoreColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c >> 10;
                    a[i] = (c & 0x3FF) << 5 | r;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 10;
                    int b = c >> 5 & 0x1F;
                    a[i] = b << 10 | g << 5 | r;
                }
                break;
            }
        }
    }

    private void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int t = a[lo];
                a[lo] = a[hi];
                a[hi] = t;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    class Cube {
        int lower;
        int upper;
        int count = 0;
        int level;
        int rmin;
        int rmax;
        int gmin;
        int gmax;
        int bmin;
        int bmax;

        Cube() {
        }

        public String toString() {
            String s = "lower=" + this.lower + " upper=" + this.upper;
            s = s + " count=" + this.count + " level=" + this.level;
            s = s + " rmin=" + this.rmin + " rmax=" + this.rmax;
            s = s + " gmin=" + this.gmin + " gmax=" + this.gmax;
            s = s + " bmin=" + this.bmin + " bmax=" + this.bmax;
            return s;
        }
    }
}

