/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Integral;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.IntegralImage;

public class IntegralVariance
implements IApplyInPlace {
    private int radius;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public IntegralVariance() {
        this(1);
    }

    public IntegralVariance(int radius) {
        this.radius = radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            IntegralImage intImage = new IntegralImage(fastBitmap);
            IntegralImage intImage2 = new IntegralImage(fastBitmap, 2);
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    float m1 = intImage.getRectangleMean(i, j, this.radius);
                    float m2 = intImage2.getRectangleMean(i, j, this.radius);
                    float val = m2 - m1 * m1;
                    fastBitmap.setGray(i, j, fastBitmap.clampValues((int)val, 0, 255));
                }
            }
        } else {
            throw new IllegalArgumentException("Integral variance only works in grayscale images.");
        }
    }
}

