/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ImageQuantization
implements IApplyInPlace {
    private int level = 16;

    public ImageQuantization() {
    }

    public ImageQuantization(int level) {
        this.level = Math.min(level, 256);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block5: {
            block4: {
                if (!fastBitmap.isGrayscale()) break block4;
                int maxG = 0;
                int size = fastBitmap.getSize();
                for (int i = 0; i < size; ++i) {
                    maxG = Math.max(maxG, fastBitmap.getGray(i));
                }
                int div = maxG / (this.level - 1);
                for (int i = 0; i < size; ++i) {
                    int g = fastBitmap.getGray(i) / div * div;
                    g = g > 255 ? 255 : g;
                    g = g < 0 ? 0 : g;
                    fastBitmap.setGray(i, g);
                }
                break block5;
            }
            if (!fastBitmap.isRGB()) break block5;
            int maxB = 0;
            int maxG = 0;
            int maxR = 0;
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                maxR = Math.max(maxR, fastBitmap.getRed(i));
                maxG = Math.max(maxG, fastBitmap.getRed(i));
                maxB = Math.max(maxB, fastBitmap.getRed(i));
            }
            int divR = maxR / (this.level - 1);
            int divG = maxG / (this.level - 1);
            int divB = maxB / (this.level - 1);
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i) / divR * divR;
                int g = fastBitmap.getGreen(i) / divG * divG;
                int b = fastBitmap.getBlue(i) / divB * divB;
                r = r > 255 ? 255 : r;
                r = r < 0 ? 0 : r;
                g = g > 255 ? 255 : g;
                g = g < 0 ? 0 : g;
                b = b > 255 ? 255 : b;
                b = b < 0 ? 0 : b;
                fastBitmap.setRGB(i, r, g, b);
            }
        }
    }
}

