/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class HomogenityEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth() - 2;
            int height = fastBitmap.getHeight() - 2;
            int stride = fastBitmap.getWidth();
            int offset = stride + 1;
            FastBitmap copy = new FastBitmap(fastBitmap);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int max = 0;
                    int v = copy.getGray(offset);
                    int d = v - copy.getGray(offset - stride - 1);
                    if (d < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset - stride)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset - stride + 1)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset - 1)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset + 1)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset + stride - 1)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset + stride)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    if ((d = v - copy.getGray(offset + stride + 1)) < 0) {
                        d = -d;
                    }
                    if (d > max) {
                        max = d;
                    }
                    fastBitmap.setGray(offset, max);
                    ++offset;
                }
                offset += 2;
            }
        } else {
            throw new IllegalArgumentException("Homogenity Edge Detector only works with grayscale images.");
        }
    }
}

