/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;

public class HistogramShrink
implements IApplyInPlace {
    private int max = 255;
    private int min = 0;

    public HistogramShrink() {
    }

    public HistogramShrink(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        ImageStatistics stat = new ImageStatistics(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            float grayMax = stat.getHistogramGray().getMax();
            float grayMin = stat.getHistogramGray().getMin();
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                float gray = fastBitmap.getGray(i);
                float shrink = (float)(this.max - this.min) / (grayMax - grayMin) * (gray - grayMin) + (float)this.min;
                fastBitmap.setGray(i, (int)shrink);
            }
        } else {
            float redMax = stat.getHistogramRed().getMax();
            float greenMax = stat.getHistogramGreen().getMax();
            float blueMax = stat.getHistogramBlue().getMax();
            float redMin = stat.getHistogramRed().getMin();
            float greenMin = stat.getHistogramGreen().getMin();
            float blueMin = stat.getHistogramBlue().getMin();
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                float r = fastBitmap.getRed(i);
                float g = fastBitmap.getGreen(i);
                float b = fastBitmap.getBlue(i);
                float shrinkRed = (float)(this.max - this.min) / (redMax - redMin) * (r - redMin) + (float)this.min;
                float shrinkGreen = (float)(this.max - this.min) / (greenMax - greenMin) * (g - greenMin) + (float)this.min;
                float shrinkBlue = (float)(this.max - this.min) / (blueMax - blueMin) * (b - blueMin) + (float)this.min;
                fastBitmap.setRGB(i, (int)shrinkRed, (int)shrinkGreen, (int)shrinkBlue);
            }
        }
    }
}

