/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;
import Catalano.Imaging.IApplyInPlace;

public class HighBoost
implements IApplyInPlace {
    private int[][] kernel = new int[][]{{-1, -1, -1}, {-1, 8, -1}, {-1, -1, -1}};
    private int boost = 8;
    private int windowSize = 3;

    public int getBoost() {
        return this.boost;
    }

    public void setBoost(int boost) {
        this.boost = boost;
        this.kernel[this.kernel.length / 2][this.kernel[0].length / 2] = boost;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        this.kernel = new int[windowSize][windowSize];
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = -1;
            }
        }
        this.setBoost(this.boost);
    }

    public HighBoost() {
    }

    public HighBoost(int boost) {
        this.setBoost(boost);
    }

    public HighBoost(int windowSize, int boost) {
        this.setWindowSize(windowSize);
        this.setBoost(boost);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        Convolution c = new Convolution(this.kernel);
        c.applyInPlace(fastBitmap);
    }
}

