/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.Functions.Gabor;

public class GaborFilter
implements IApplyInPlace {
    private int size = 3;
    private double lambda = 4.0;
    private double theta = 0.6;
    private double psi = 1.0;
    private double sigma = 2.0;
    private double gamma = 0.3;
    private Gabor.Config config = Gabor.Config.Imaginary;
    private boolean signed = false;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public double getWavelength() {
        return this.lambda;
    }

    public void setWavelength(double lambda) {
        this.lambda = lambda;
    }

    public double getOrientation() {
        return this.theta;
    }

    public void setOrientation(double theta) {
        this.theta = theta;
    }

    public double getPhaseOffset() {
        return this.psi;
    }

    public void setPhaseOffset(double psi) {
        this.psi = psi;
    }

    public double getGaussianVar() {
        return this.sigma;
    }

    public void setGaussianVar(double sigma) {
        this.sigma = sigma;
    }

    public double getAspectRatio() {
        return this.gamma;
    }

    public void setAspectRatio(double gamma) {
        this.gamma = gamma;
    }

    public Gabor.Config getConfig() {
        return this.config;
    }

    public void setConfig(Gabor.Config config) {
        this.config = config;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public GaborFilter() {
    }

    public GaborFilter(double wavelength) {
        this.lambda = wavelength;
    }

    public GaborFilter(double wavelength, double orientation) {
        this.lambda = wavelength;
        this.theta = orientation;
    }

    public GaborFilter(double wavelength, double orientation, double phaseOffset) {
        this.lambda = wavelength;
        this.theta = orientation;
        this.psi = phaseOffset;
    }

    public GaborFilter(double wavelength, double orientation, double phaseOffset, double gaussianVar) {
        this.lambda = wavelength;
        this.theta = orientation;
        this.psi = phaseOffset;
        this.sigma = gaussianVar;
    }

    public GaborFilter(double wavelength, double orientation, double phaseOffset, double gaussianVar, double aspectRatio) {
        this.lambda = wavelength;
        this.theta = orientation;
        this.psi = phaseOffset;
        this.sigma = gaussianVar;
        this.gamma = aspectRatio;
    }

    public GaborFilter(double wavelength, double orientation, double phaseOffset, double gaussianVar, double aspectRatio, Gabor.Config config) {
        this.lambda = wavelength;
        this.theta = orientation;
        this.psi = phaseOffset;
        this.sigma = gaussianVar;
        this.gamma = aspectRatio;
        this.config = config;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            double[][] gaborKernel = Gabor.Kernel2D(this.size, this.lambda, this.theta, this.psi, this.sigma, this.gamma, this.config);
            int[][] gaborResponse = this.applyGabor(fastBitmap, gaborKernel);
            int maxG = Integer.MIN_VALUE;
            int minG = Integer.MAX_VALUE;
            if (this.isSigned()) {
                int j;
                int i;
                fastBitmap.toRGB();
                for (i = 0; i < gaborResponse.length; ++i) {
                    for (j = 0; j < gaborResponse[0].length; ++j) {
                        int gray = gaborResponse[i][j];
                        if (gray > maxG && gray > 0) {
                            maxG = gray;
                        }
                        if (gray >= minG || gray >= 0) continue;
                        minG = gray;
                    }
                }
                for (i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        int g = (int)Math.round(255.0 * ((double)gaborResponse[i][j] / (double)maxG));
                        if (gaborResponse[i][j] < 0) {
                            g = (int)Math.round(255.0 * ((double)gaborResponse[i][j] / (double)minG));
                        }
                        if (gaborResponse[i][j] > 0) {
                            fastBitmap.setRGB(i, j, g, 0, 0);
                            continue;
                        }
                        fastBitmap.setRGB(i, j, 0, 0, g);
                    }
                }
            } else {
                int j;
                int i;
                for (i = 0; i < gaborResponse.length; ++i) {
                    for (j = 0; j < gaborResponse[0].length; ++j) {
                        int gray = gaborResponse[i][j];
                        if (gray > maxG) {
                            maxG = gray;
                        }
                        if (gray >= minG) continue;
                        minG = gray;
                    }
                }
                for (i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        int g = (int)Math.round(255.0 * (double)(gaborResponse[i][j] - minG) / (double)(maxG - minG));
                        fastBitmap.setGray(i, j, g);
                    }
                }
            }
        } else {
            try {
                throw new IllegalArgumentException("Gabor filter only works with grayscale images.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int[][] applyGabor(FastBitmap fastBitmap, double[][] gaborKernel) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        int xmax = (int)Math.floor((double)gaborKernel.length / 2.0);
        int ymax = (int)Math.floor((double)gaborKernel[0].length / 2.0);
        int[][] gaborResponse = new int[height][width];
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                double sum = 0.0;
                for (int xf = -xmax; xf <= xmax; ++xf) {
                    for (int yf = -ymax; yf <= ymax; ++yf) {
                        if (x - xf < 0 || x - xf >= height || y - yf < 0 || y - yf >= width) continue;
                        int value = fastBitmap.getGray(x - xf, y - yf);
                        sum += gaborKernel[xf + xmax][yf + ymax] * (double)value;
                    }
                }
                gaborResponse[x][y] = (int)Math.round(sum);
            }
        }
        return gaborResponse;
    }
}

