/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.BinaryDilatation;
import Catalano.Imaging.Filters.BinaryErosion;
import Catalano.Imaging.Filters.Difference;
import Catalano.Imaging.IApplyInPlace;
import java.util.ArrayList;

public class ExtractBoundary
implements IApplyInPlace {
    private Algorithm algorithm = Algorithm.Erosion;
    private ArrayList<IntPoint> points;

    public ExtractBoundary() {
    }

    public ExtractBoundary(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap l = new FastBitmap(fastBitmap);
        if (this.algorithm == Algorithm.Erosion) {
            BinaryErosion ero = new BinaryErosion();
            ero.applyInPlace(l);
        } else {
            BinaryDilatation dil = new BinaryDilatation();
            dil.applyInPlace(l);
        }
        Difference dif = new Difference(fastBitmap);
        dif.applyInPlace(l);
        fastBitmap.setImage(l);
    }

    public ArrayList<IntPoint> ProcessImage(FastBitmap fastBitmap) {
        FastBitmap l = new FastBitmap(fastBitmap);
        if (this.points == null) {
            this.applyInPlace(l);
        }
        int width = l.getWidth();
        int height = l.getHeight();
        this.points = new ArrayList();
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                if (l.getGray(x, y) != 255) continue;
                this.points.add(new IntPoint(x, y));
            }
        }
        return this.points;
    }

    public static enum Algorithm {
        Erosion,
        Dilatation;

    }
}

