/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Statistics.Correlations;

public class DisparityMap {
    private int sizeBlock = 15;
    private int distance = 64;

    public DisparityMap() {
    }

    public DisparityMap(int sizeBlock) {
        this.sizeBlock = sizeBlock;
    }

    public double[][] Process(FastBitmap left, FastBitmap right) {
        if (left.isRGB()) {
            left.toGrayscale();
        }
        if (right.isRGB()) {
            right.toGrayscale();
        }
        int width = left.getWidth();
        int height = left.getHeight();
        double[][] map = new double[height][width];
        for (int i = 0; i < height - this.sizeBlock; ++i) {
            for (int j = 0; j < width - this.sizeBlock; ++j) {
                double min = Double.MAX_VALUE;
                double z = 0.0;
                FastBitmap a = this.getSubimage(left, i, j, this.sizeBlock, this.sizeBlock);
                for (int k = j - this.distance; k < j; ++k) {
                    FastBitmap b;
                    double dist;
                    if (!(k < width - this.sizeBlock & k > 0) || !((dist = this.PearsonDistance(a, b = this.getSubimage(right, i, k, this.sizeBlock, this.sizeBlock))) <= min)) continue;
                    min = dist;
                    z = Math.abs(j - k);
                }
                map[i + this.sizeBlock][j + this.sizeBlock] = z;
            }
        }
        return map;
    }

    private double PearsonDistance(FastBitmap a, FastBitmap b) {
        int size = this.sizeBlock * this.sizeBlock;
        double[] x = new double[size];
        double[] y = new double[size];
        for (int i = 0; i < size; ++i) {
            x[i] = a.getGray(i);
            y[i] = b.getGray(i);
        }
        return 1.0 - Correlations.PearsonCorrelation(x, y);
    }

    private FastBitmap getSubimage(FastBitmap fastBitmap, int x, int y, int width, int height) {
        FastBitmap copy = new FastBitmap(this.sizeBlock, this.sizeBlock, FastBitmap.ColorSpace.Grayscale);
        for (int i = x; i < x + height; ++i) {
            for (int j = y; j < y + width; ++j) {
                copy.setGray(i - x, j - y, fastBitmap.getGray(i, j));
            }
        }
        return copy;
    }
}

