/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class DifferenceEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            FastBitmap copy = new FastBitmap(fastBitmap);
            int width = copy.getWidth() - 2;
            int height = copy.getHeight() - 2;
            int stride = fastBitmap.getWidth();
            int offset = stride + 1;
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int max = 0;
                    int diff = copy.getGray(offset - stride - 1) - copy.getGray(offset + stride + 1);
                    if (diff < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    if ((diff = copy.getGray(offset - stride) - copy.getGray(offset + stride)) < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    if ((diff = copy.getGray(offset - stride + 1) - copy.getGray(offset + stride - 1)) < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    if ((diff = copy.getGray(offset + 1) - copy.getGray(offset - 1)) < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    fastBitmap.setGray(offset, max);
                    ++offset;
                }
                offset += 2;
            }
        } else {
            throw new IllegalArgumentException("DifferenceEdgeDetector only works in grayscale images.");
        }
    }
}

