/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Shapes.IntRectangle;

public class Crop
implements IApply,
IApplyInPlace {
    private int x;
    private int y;
    private int width;
    private int height;

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setSize(int height, int width) {
        this.height = height;
        this.width = width;
    }

    public Crop(IntRectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Crop(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        if (this.x + this.height > fastBitmap.getHeight() || this.y + this.width > fastBitmap.getWidth()) {
            throw new IllegalArgumentException("The size is higher than original image.");
        }
        FastBitmap l = new FastBitmap(this.width, this.height, fastBitmap.getColorSpace());
        if (fastBitmap.isGrayscale()) {
            if (fastBitmap.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
                for (int r = 0; r < this.height; ++r) {
                    for (int c = 0; c < this.width; ++c) {
                        l.setGray(r, c, fastBitmap.getGray(r + this.x, c + this.y));
                    }
                }
            } else {
                for (int r = 0; r < this.height; ++r) {
                    for (int c = 0; c < this.width; ++c) {
                        l.setGray(c, r, fastBitmap.getGray(r + this.y, c + this.x));
                    }
                }
            }
        } else if (fastBitmap.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
            for (int r = 0; r < this.height; ++r) {
                for (int c = 0; c < this.width; ++c) {
                    l.setRed(r, c, fastBitmap.getRed(r + this.x, c + this.y));
                    l.setGreen(r, c, fastBitmap.getGreen(r + this.x, c + this.y));
                    l.setBlue(r, c, fastBitmap.getBlue(r + this.x, c + this.y));
                }
            }
        } else {
            for (int r = 0; r < this.height; ++r) {
                for (int c = 0; c < this.width; ++c) {
                    l.setRed(c, r, fastBitmap.getRed(r + this.y, c + this.x));
                    l.setGreen(c, r, fastBitmap.getGreen(r + this.y, c + this.x));
                    l.setBlue(c, r, fastBitmap.getBlue(r + this.y, c + this.x));
                }
            }
        }
        return l;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }
}

