/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.LevelsLinear;
import Catalano.Imaging.IApplyInPlace;

public class ContrastCorrection
implements IApplyInPlace {
    private LevelsLinear baseFilter = new LevelsLinear();
    private int factor = 10;

    public int getFactor() {
        return this.factor;
    }

    public void setFactor(int factor) {
        this.factor = factor = Math.max(-127, Math.min(127, factor));
        if (factor > 1) {
            this.baseFilter.setInRed(new IntRange(factor, 255 - factor));
            this.baseFilter.setInGreen(new IntRange(factor, 255 - factor));
            this.baseFilter.setInBlue(new IntRange(factor, 255 - factor));
            this.baseFilter.setInGray(new IntRange(factor, 255 - factor));
            this.baseFilter.setOutRed(new IntRange(0, 255));
            this.baseFilter.setOutGreen(new IntRange(0, 255));
            this.baseFilter.setOutBlue(new IntRange(0, 255));
            this.baseFilter.setOutGray(new IntRange(0, 255));
        } else {
            this.baseFilter.setInRed(new IntRange(-factor, 255 + factor));
            this.baseFilter.setInGreen(new IntRange(-factor, 255 + factor));
            this.baseFilter.setInBlue(new IntRange(-factor, 255 + factor));
            this.baseFilter.setInGray(new IntRange(-factor, 255 + factor));
            this.baseFilter.setOutRed(new IntRange(0, 255));
            this.baseFilter.setOutGreen(new IntRange(0, 255));
            this.baseFilter.setOutBlue(new IntRange(0, 255));
            this.baseFilter.setOutGray(new IntRange(0, 255));
        }
    }

    public ContrastCorrection() {
    }

    public ContrastCorrection(int factor) {
        this.setFactor(factor);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.baseFilter.applyInPlace(fastBitmap);
    }
}

