/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ColorFiltering
implements IApplyInPlace {
    private IntRange red;
    private IntRange green;
    private IntRange blue;

    public IntRange getRed() {
        return this.red;
    }

    public void setRed(IntRange red) {
        this.red = red;
    }

    public IntRange getGreen() {
        return this.green;
    }

    public void setGreen(IntRange green) {
        this.green = green;
    }

    public IntRange getBlue() {
        return this.blue;
    }

    public void setBlue(IntRange blue) {
        this.blue = blue;
    }

    public ColorFiltering() {
    }

    public ColorFiltering(IntRange red, IntRange green, IntRange blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                if (r >= this.red.getMin() && r <= this.red.getMax() && g >= this.green.getMin() && g <= this.green.getMax() && b >= this.blue.getMin() && b <= this.blue.getMax()) {
                    fastBitmap.setRGB(i, r, g, b);
                    continue;
                }
                fastBitmap.setRGB(i, 0, 0, 0);
            }
        } else {
            throw new IllegalArgumentException("Color filtering only works in RGB images.");
        }
    }
}

