/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.IntegralImage;

public class BradleyLocalThreshold
implements IApplyInPlace {
    private int windowSize = 41;
    private float pixelBrightnessDifferenceLimit = 0.15f;

    public BradleyLocalThreshold() {
    }

    public BradleyLocalThreshold(int windowSize) {
        this.windowSize = windowSize;
    }

    public BradleyLocalThreshold(int windowSize, float pixelBrightnessDiff) {
        this.windowSize = windowSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public float getPixelBrightnessDifferenceLimit() {
        return this.pixelBrightnessDifferenceLimit;
    }

    public void setPixelBrightnessDifferenceLimit(float pixelBrightnessDifferenceLimit) {
        this.pixelBrightnessDifferenceLimit = pixelBrightnessDifferenceLimit;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        IntegralImage im = new IntegralImage(fastBitmap);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int widthM1 = width - 1;
        int heightM1 = height - 1;
        int radius = this.windowSize / 2;
        float avgBrightnessPart = 1.0f - this.pixelBrightnessDifferenceLimit;
        for (int x = 0; x < height; ++x) {
            int x1 = x - radius;
            int x2 = x + radius;
            if (x1 < 0) {
                x1 = 0;
            }
            if (x2 > heightM1) {
                x2 = heightM1;
            }
            for (int y = 0; y < width; ++y) {
                int y1 = y - radius;
                int y2 = y + radius;
                if (y1 < 0) {
                    y1 = 0;
                }
                if (y2 > widthM1) {
                    y2 = widthM1;
                }
                int gray = fastBitmap.getGray(x, y) < (int)(im.getRectangleMeanUnsafe(x1, y1, x2, y2) * avgBrightnessPart) ? 0 : 255;
                fastBitmap.setGray(x, y, gray);
            }
        }
    }
}

