/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.DistanceTransform;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BinaryWatershed
implements IApplyInPlace {
    private final int[] DIR_X_OFFSET = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private final int[] DIR_Y_OFFSET = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
    private int[] dirOffset;
    private final float SQRT2 = 1.4142135f;
    private int intEncodeXMask;
    private int intEncodeYMask;
    private int intEncodeShift;
    private DistanceTransform.Distance distance = DistanceTransform.Distance.Euclidean;
    private float tolerance = 0.5f;

    public BinaryWatershed() {
    }

    public BinaryWatershed(float tolerance) {
        this.tolerance = tolerance;
    }

    public BinaryWatershed(float tolerance, DistanceTransform.Distance distance) {
        this.tolerance = tolerance;
        this.distance = distance;
    }

    public BinaryWatershed(DistanceTransform.Distance distance) {
        this.distance = distance;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Binary Watershed only works in grayscale (binary) images");
        }
        this.Watershed(fastBitmap);
    }

    private void Watershed(FastBitmap fastBitmap) {
        DistanceTransform dt = new DistanceTransform(this.distance);
        float[][] distance = dt.Compute(fastBitmap);
        float[] distance1D = new float[distance.length * distance[0].length];
        int p = 0;
        for (int i = 0; i < fastBitmap.getHeight(); ++i) {
            for (int j = 0; j < fastBitmap.getWidth(); ++j) {
                distance1D[p++] = distance[i][j];
            }
        }
        this.makeDirectionOffsets(distance[0].length);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        FastBitmap back = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
        long[] maxPoints = this.getSortedMaxPoints(distance, distance1D, back, 0.0f, dt.getMaximumDistance(), -808080.0);
        float maxSortingError = 0.7778175f;
        this.analyseAndMarkMaxima(distance1D, back, maxPoints, this.tolerance, maxSortingError);
        FastBitmap outImage = this.make8Bit(distance, back, dt.getMaximumDistance(), -808080.0);
        this.cleanupMaxima(outImage, back, maxPoints);
        this.watershedSegment(outImage);
        BinaryWatershed.watershedPostProcess(outImage);
        fastBitmap.setImage(outImage);
    }

    private void makeDirectionOffsets(int width) {
        int shift = 0;
        int mult = 1;
        do {
            ++shift;
        } while ((mult *= 2) < width);
        this.intEncodeXMask = mult - 1;
        this.intEncodeYMask = ~this.intEncodeXMask;
        this.intEncodeShift = shift;
        this.dirOffset = new int[]{-width, -width + 1, 1, width + 1, width, width - 1, -1, -width - 1};
    }

    private long[] getSortedMaxPoints(float[][] distance, float[] distance1D, FastBitmap back, float globalMin, float globalMax, double threshold) {
        byte[] types = back.getGrayData();
        int nMax = 0;
        for (int y = 0; y < distance.length; ++y) {
            int x = 0;
            int i = x + y * distance[0].length;
            while (x < distance[0].length) {
                float v = distance[y][x];
                float vTrue = this.trueEdmHeight(x, y, distance1D, distance[0].length, distance.length);
                if (v != globalMin && x != 0 && x != distance[0].length - 1 && y != 0 && y != distance.length - 1 && !((double)v < threshold)) {
                    boolean isMax = true;
                    boolean isInner = y != 0 && y != distance.length - 1 && x != 0 && x != distance[0].length - 1;
                    for (int d = 0; d < 8; ++d) {
                        if (!isInner && !this.isWithin(x, y, d, distance[0].length, distance.length)) continue;
                        float vNeighbor = distance[y + this.DIR_Y_OFFSET[d]][x + this.DIR_X_OFFSET[d]];
                        float vNeighborTrue = this.trueEdmHeight(x + this.DIR_X_OFFSET[d], y + this.DIR_Y_OFFSET[d], distance1D, distance[0].length, distance.length);
                        if (!(vNeighbor > v) || !(vNeighborTrue > vTrue)) continue;
                        isMax = false;
                        break;
                    }
                    if (isMax) {
                        types[i] = 1;
                        ++nMax;
                    }
                }
                ++x;
                ++i;
            }
        }
        float vFactor = (float)(2.0E9 / (double)(globalMax - globalMin));
        long[] maxPoints = new long[nMax];
        int iMax = 0;
        for (int y = 0; y < distance.length; ++y) {
            int x = 0;
            int pp = x + y * distance[0].length;
            while (x < distance[0].length) {
                if (types[pp] == 1) {
                    float fValue = this.trueEdmHeight(x, y, distance1D, distance[0].length, distance.length);
                    int iValue = (int)((fValue - globalMin) * vFactor);
                    maxPoints[iMax++] = (long)iValue << 32 | (long)pp;
                }
                ++x;
                ++pp;
            }
        }
        Arrays.sort(maxPoints);
        return maxPoints;
    }

    private List<IntPoint> analyseAndMarkMaxima(float[] edmPixels, FastBitmap back, long[] maxPoints, float tolerance, float maxSortingError) {
        ArrayList<IntPoint> uep = new ArrayList<IntPoint>();
        int width = back.getWidth();
        int height = back.getHeight();
        byte[] types = back.getGrayData();
        int nMax = maxPoints.length;
        int[] pList = new int[width * height];
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            boolean sortingError;
            int offset0 = (int)maxPoints[iMax];
            if ((types[offset0] & 4) != 0) continue;
            int x0 = offset0 % width;
            int y0 = offset0 / width;
            float v0 = this.trueEdmHeight(x0, y0, edmPixels, width, height);
            do {
                pList[0] = offset0;
                int n = offset0;
                types[n] = (byte)(types[n] | 0x12);
                int listLen = 1;
                int listI = 0;
                sortingError = false;
                boolean maxPossible = true;
                double xEqual = x0;
                double yEqual = y0;
                int nEqual = 1;
                block2: do {
                    int offset = pList[listI];
                    int x = offset % width;
                    int y = offset / width;
                    boolean isInner = y != 0 && y != height - 1 && x != 0 && x != width - 1;
                    for (int d = 0; d < 8; ++d) {
                        int offset2 = offset + this.dirOffset[d];
                        if (!isInner && !this.isWithin(x, y, d, width, height) || (types[offset2] & 2) != 0 || edmPixels[offset2] <= 0.0f) continue;
                        if ((types[offset2] & 4) != 0) {
                            maxPossible = false;
                            continue block2;
                        }
                        int x2 = x + this.DIR_X_OFFSET[d];
                        int y2 = y + this.DIR_Y_OFFSET[d];
                        float v2 = this.trueEdmHeight(x2, y2, edmPixels, width, height);
                        if (v2 > v0 + maxSortingError) {
                            maxPossible = false;
                            continue block2;
                        }
                        if (!(v2 >= v0 - tolerance)) continue;
                        if (v2 > v0) {
                            sortingError = true;
                            offset0 = offset2;
                            v0 = v2;
                            x0 = x2;
                            y0 = y2;
                        }
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                        if (v2 != v0) continue;
                        int n3 = offset2;
                        types[n3] = (byte)(types[n3] | 0x10);
                        xEqual += (double)x2;
                        yEqual += (double)y2;
                        ++nEqual;
                    }
                } while (++listI < listLen);
                if (sortingError) {
                    for (listI = 0; listI < listLen; ++listI) {
                        types[pList[listI]] = 0;
                    }
                } else {
                    int offset;
                    int resetMask = ~(maxPossible ? 2 : 18);
                    xEqual /= (double)nEqual;
                    yEqual /= (double)nEqual;
                    double minDist2 = 1.0E20;
                    int nearestI = 0;
                    for (listI = 0; listI < listLen; ++listI) {
                        double dist2;
                        offset = pList[listI];
                        int x = offset % width;
                        int y = offset / width;
                        int n4 = offset;
                        types[n4] = (byte)(types[n4] & resetMask);
                        int n5 = offset;
                        types[n5] = (byte)(types[n5] | 4);
                        if (!maxPossible) continue;
                        int n6 = offset;
                        types[n6] = (byte)(types[n6] | 8);
                        if ((types[offset] & 0x10) == 0 || !((dist2 = (xEqual - (double)x) * (xEqual - (double)x) + (yEqual - (double)y) * (yEqual - (double)y)) < minDist2)) continue;
                        minDist2 = dist2;
                        nearestI = listI;
                    }
                    if (!maxPossible) continue;
                    offset = pList[nearestI];
                    uep.add(new IntPoint(offset / width, offset % width));
                    int n7 = offset;
                    types[n7] = (byte)(types[n7] | 0x20);
                }
            } while (sortingError);
        }
        return uep;
    }

    private FastBitmap make8Bit(float[][] distance, FastBitmap back, float globalMax, double threshold) {
        int width = distance[0].length;
        int height = distance.length;
        byte[] types = back.getGrayData();
        threshold = 0.5;
        double minValue = 1.0;
        double offset = minValue - ((double)globalMax - minValue) * 0.001975284584980237;
        double factor = 253.0 / ((double)globalMax - minValue);
        if (factor > 1.0) {
            factor = 1.0;
        }
        FastBitmap outIp = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
        byte[] pixels = outIp.getGrayData();
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                long v;
                float rawValue = distance[y][x];
                pixels[i] = (double)rawValue < threshold ? 0 : ((types[i] & 8) != 0 ? -1 : ((v = 1L + Math.round(((double)rawValue - offset) * factor)) < 1L ? 1 : (v <= 254L ? (int)((int)(v & 0xFFL)) : -2)));
                ++x;
                ++i;
            }
        }
        return outIp;
    }

    private void cleanupMaxima(FastBitmap outIp, FastBitmap typeP, long[] maxPoints) {
        int width = outIp.getWidth();
        int height = outIp.getHeight();
        byte[] pixels = outIp.getGrayData();
        byte[] types = typeP.getGrayData();
        int nMax = maxPoints.length;
        int[] pList = new int[width * height];
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            int offset;
            int offset0 = (int)maxPoints[iMax];
            if ((types[offset0] & 0x48) != 0) continue;
            int level = pixels[offset0] & 0xFF;
            int loLevel = level + 1;
            pList[0] = offset0;
            int n = offset0;
            types[n] = (byte)(types[n] | 2);
            int listLen = 1;
            int lastLen = 1;
            int listI = 0;
            boolean saddleFound = false;
            while (!saddleFound && loLevel > 0) {
                --loLevel;
                lastLen = listLen;
                listI = 0;
                block2: do {
                    offset = pList[listI];
                    int x = offset % width;
                    int y = offset / width;
                    boolean isInner = y != 0 && y != height - 1 && x != 0 && x != width - 1;
                    for (int d = 0; d < 8; ++d) {
                        int offset2 = offset + this.dirOffset[d];
                        if (!isInner && !this.isWithin(x, y, d, width, height) || (types[offset2] & 2) != 0) continue;
                        if ((types[offset2] & 8) != 0 || (types[offset2] & 0x40) != 0 && (pixels[offset2] & 0xFF) >= loLevel) {
                            saddleFound = true;
                            continue block2;
                        }
                        if ((pixels[offset2] & 0xFF) < loLevel || (types[offset2] & 0x40) != 0) continue;
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                    }
                } while (!saddleFound && ++listI < listLen);
            }
            for (listI = 0; listI < listLen; ++listI) {
                int n3 = pList[listI];
                types[n3] = (byte)(types[n3] & 0xFFFFFFFD);
            }
            for (listI = 0; listI < lastLen; ++listI) {
                offset = pList[listI];
                pixels[offset] = (byte)loLevel;
                int n4 = offset;
                types[n4] = (byte)(types[n4] | 0x40);
            }
        }
    }

    private boolean watershedSegment(FastBitmap ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] pixels = ip.getGrayData();
        ImageStatistics is = new ImageStatistics(ip);
        int[] histogram = is.getHistogramGray().getValues();
        int arraySize = width * height - histogram[0] - histogram[255];
        int[] coordinates = new int[arraySize];
        int highestValue = 0;
        int maxBinSize = 0;
        int offset = 0;
        int[] levelStart = new int[256];
        for (int v = 1; v < 255; ++v) {
            levelStart[v] = offset;
            offset += histogram[v];
            if (histogram[v] > 0) {
                highestValue = v;
            }
            if (histogram[v] <= maxBinSize) continue;
            maxBinSize = histogram[v];
        }
        int[] levelOffset = new int[highestValue + 1];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int v = pixels[i] & 0xFF;
                if (v > 0 && v < 255) {
                    offset = levelStart[v] + levelOffset[v];
                    coordinates[offset] = x | y << this.intEncodeShift;
                    int n = v;
                    levelOffset[n] = levelOffset[n] + 1;
                }
                ++x;
                ++i;
            }
        }
        int[] setPointList = new int[Math.min(maxBinSize, (width * height + 2) / 3)];
        int[] table = this.makeFateTable();
        int[] directionSequence = new int[]{7, 3, 1, 5, 0, 4, 2, 6};
        for (int level = highestValue; level >= 1; --level) {
            int remaining = histogram[level];
            int idle = 0;
            while (remaining > 0 && idle < 8) {
                int dIndex = 0;
                do {
                    int n = this.processLevel(directionSequence[dIndex % 8], ip, table, levelStart[level], remaining, coordinates, setPointList);
                    remaining -= n;
                    if (n > 0) {
                        idle = 0;
                    }
                    ++dIndex;
                } while (remaining > 0 && idle++ < 8);
            }
            if (remaining <= 0 || level <= 1) continue;
            int nextLevel = level;
            while (--nextLevel > 1 && histogram[nextLevel] == 0) {
            }
            if (nextLevel <= 0) continue;
            int newNextLevelEnd = levelStart[nextLevel] + histogram[nextLevel];
            int i2 = 0;
            int p = levelStart[level];
            while (i2 < remaining) {
                int xy = coordinates[p];
                int x = xy & this.intEncodeXMask;
                int y = (xy & this.intEncodeYMask) >> this.intEncodeShift;
                int pOffset = x + y * width;
                boolean addToNext = false;
                if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                    addToNext = true;
                } else {
                    for (int d = 0; d < 8; ++d) {
                        if (!this.isWithin(x, y, d, width, height) || pixels[pOffset + this.dirOffset[d]] != 0) continue;
                        addToNext = true;
                        break;
                    }
                }
                if (addToNext) {
                    coordinates[newNextLevelEnd++] = xy;
                }
                ++i2;
                ++p;
            }
            histogram[nextLevel] = newNextLevelEnd - levelStart[nextLevel];
        }
        return true;
    }

    private int processLevel(int pass, FastBitmap ip, int[] fateTable, int levelStart, int levelNPoints, int[] coordinates, int[] setPointList) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int xmax = width - 1;
        int ymax = height - 1;
        byte[] pixels = ip.getGrayData();
        int nChanged = 0;
        int nUnchanged = 0;
        int i = 0;
        int p = levelStart;
        while (i < levelNPoints) {
            int mask;
            int xy = coordinates[p];
            int x = xy & this.intEncodeXMask;
            int y = (xy & this.intEncodeYMask) >> this.intEncodeShift;
            int offset = x + y * width;
            int index = 0;
            if (y > 0 && (pixels[offset - width] & 0xFF) == 255) {
                index ^= 1;
            }
            if (x < xmax && y > 0 && (pixels[offset - width + 1] & 0xFF) == 255) {
                index ^= 2;
            }
            if (x < xmax && (pixels[offset + 1] & 0xFF) == 255) {
                index ^= 4;
            }
            if (x < xmax && y < ymax && (pixels[offset + width + 1] & 0xFF) == 255) {
                index ^= 8;
            }
            if (y < ymax && (pixels[offset + width] & 0xFF) == 255) {
                index ^= 0x10;
            }
            if (x > 0 && y < ymax && (pixels[offset + width - 1] & 0xFF) == 255) {
                index ^= 0x20;
            }
            if (x > 0 && (pixels[offset - 1] & 0xFF) == 255) {
                index ^= 0x40;
            }
            if (x > 0 && y > 0 && (pixels[offset - width - 1] & 0xFF) == 255) {
                index ^= 0x80;
            }
            if ((fateTable[index] & (mask = 1 << pass)) == mask) {
                setPointList[nChanged++] = offset;
            } else {
                coordinates[levelStart + nUnchanged++] = xy;
            }
            ++i;
            ++p;
        }
        for (i = 0; i < nChanged; ++i) {
            pixels[setPointList[i]] = -1;
        }
        return nChanged;
    }

    private int[] makeFateTable() {
        int[] table = new int[256];
        boolean[] isSet = new boolean[8];
        for (int item = 0; item < 256; ++item) {
            int i;
            int mask = 1;
            for (i = 0; i < 8; ++i) {
                isSet[i] = (item & mask) == mask;
                mask *= 2;
            }
            mask = 1;
            for (i = 0; i < 8; ++i) {
                if (isSet[(i + 4) % 8]) {
                    int n = item;
                    table[n] = table[n] | mask;
                }
                mask *= 2;
            }
            for (i = 0; i < 8; i += 2) {
                if (!isSet[i]) continue;
                isSet[(i + 1) % 8] = true;
                isSet[(i + 7) % 8] = true;
            }
            int transitions = 0;
            boolean mask2 = true;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (isSet[i2] == isSet[(i2 + 1) % 8]) continue;
                ++transitions;
            }
            if (transitions < 4) continue;
            table[item] = 0;
        }
        return table;
    }

    private boolean isWithin(int x, int y, int direction, int width, int height) {
        int xmax = width - 1;
        int ymax = height - 1;
        switch (direction) {
            case 0: {
                return y > 0;
            }
            case 1: {
                return x < xmax && y > 0;
            }
            case 2: {
                return x < xmax;
            }
            case 3: {
                return x < xmax && y < ymax;
            }
            case 4: {
                return y < ymax;
            }
            case 5: {
                return x > 0 && y < ymax;
            }
            case 6: {
                return x > 0;
            }
            case 7: {
                return x > 0 && y > 0;
            }
        }
        return false;
    }

    private float trueEdmHeight(int x, int y, float[] pixels, int width, int height) {
        int xmax = width - 1;
        int ymax = height - 1;
        int offset = x + y * width;
        float v = pixels[offset];
        if (x == 0 || y == 0 || x == xmax || y == ymax || v == 0.0f) {
            return v;
        }
        float trueH = v + 0.70710677f;
        boolean ridgeOrMax = false;
        for (int d = 0; d < 4; ++d) {
            float h;
            int d2 = (d + 4) % 8;
            float v1 = pixels[offset + this.dirOffset[d]];
            float v2 = pixels[offset + this.dirOffset[d2]];
            if (v >= v1 && v >= v2) {
                ridgeOrMax = true;
                h = (v1 + v2) / 2.0f;
            } else {
                h = Math.min(v1, v2);
            }
            h += d % 2 == 0 ? 1.0f : 1.4142135f;
            if (!(trueH > h)) continue;
            trueH = h;
        }
        if (!ridgeOrMax) {
            trueH = v;
        }
        return trueH;
    }

    private static void watershedPostProcess(FastBitmap ip) {
        byte[] pixels = ip.getGrayData();
        int size = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < size; ++i) {
            if ((pixels[i] & 0xFF) >= 255) continue;
            pixels[i] = 0;
        }
    }
}

