/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging;

import Catalano.Core.IntPoint;
import Catalano.Imaging.Color;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Shapes.IntPolygon;
import Catalano.Imaging.Shapes.IntRectangle;
import java.util.List;

public class FastGraphics {
    private FastBitmap fastBitmap;
    private Color color;
    private int gray = 0;

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int red, int green, int blue) {
        this.color = new Color(red, green, blue);
    }

    public void setColor(int gray) {
        this.gray = gray;
    }

    public void setImage(FastBitmap fastBitmap) {
        this.fastBitmap = fastBitmap;
    }

    public FastGraphics(FastBitmap fastBitmap) {
        this.fastBitmap = fastBitmap;
    }

    public void DrawCircle(IntPoint p, int radius) {
        this.DrawCircle(p.x, p.y, radius);
    }

    public void DrawCircle(int x, int y, int radius) {
        if (this.fastBitmap.isRGB()) {
            int i = radius;
            int radiusError = 1 - i;
            for (int j = 0; i >= j; ++j) {
                this.fastBitmap.setRGB(i + x, j + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(j + x, i + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(-i + x, j + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(-j + x, i + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(-i + x, -j + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(-j + x, -i + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(i + x, -j + y, this.color.r, this.color.g, this.color.b);
                this.fastBitmap.setRGB(j + x, -i + y, this.color.r, this.color.g, this.color.b);
                if (radiusError < 0) {
                    radiusError += 2 * j + 1;
                    continue;
                }
                radiusError += 2 * (j - --i + 1);
            }
        } else {
            int i = radius;
            int radiusError = 1 - i;
            for (int j = 0; i >= j; ++j) {
                this.fastBitmap.setGray(i + x, j + y, this.gray);
                this.fastBitmap.setGray(j + x, i + y, this.gray);
                this.fastBitmap.setGray(-i + x, j + y, this.gray);
                this.fastBitmap.setGray(-j + x, i + y, this.gray);
                this.fastBitmap.setGray(-i + x, -j + y, this.gray);
                this.fastBitmap.setGray(-j + x, -i + y, this.gray);
                this.fastBitmap.setGray(i + x, -j + y, this.gray);
                this.fastBitmap.setGray(j + x, -i + y, this.gray);
                if (radiusError < 0) {
                    radiusError += 2 * j + 1;
                    continue;
                }
                radiusError += 2 * (j - --i + 1);
            }
        }
    }

    public void DrawLine(IntPoint p, IntPoint q) {
        this.DrawLine(p.x, p.y, q.x, q.y);
    }

    public void DrawLine(int x, int y, int x2, int y2) {
        if (this.fastBitmap.isRGB()) {
            int w = x2 - x;
            int h = y2 - y;
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = 0;
            int dy2 = 0;
            if (w < 0) {
                dx1 = -1;
            } else if (w > 0) {
                dx1 = 1;
            }
            if (h < 0) {
                dy1 = -1;
            } else if (h > 0) {
                dy1 = 1;
            }
            if (w < 0) {
                dx2 = -1;
            } else if (w > 0) {
                dx2 = 1;
            }
            int longest = Math.abs(w);
            int shortest = Math.abs(h);
            if (longest <= shortest) {
                longest = Math.abs(h);
                shortest = Math.abs(w);
                if (h < 0) {
                    dy2 = -1;
                } else if (h > 0) {
                    dy2 = 1;
                }
                dx2 = 0;
            }
            int numerator = longest >> 1;
            for (int i = 0; i <= longest; ++i) {
                this.fastBitmap.setRGB(x, y, this.color.r, this.color.g, this.color.b);
                if ((numerator += shortest) >= longest) {
                    numerator -= longest;
                    x += dx1;
                    y += dy1;
                    continue;
                }
                x += dx2;
                y += dy2;
            }
        } else {
            int w = x2 - x;
            int h = y2 - y;
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = 0;
            int dy2 = 0;
            if (w < 0) {
                dx1 = -1;
            } else if (w > 0) {
                dx1 = 1;
            }
            if (h < 0) {
                dy1 = -1;
            } else if (h > 0) {
                dy1 = 1;
            }
            if (w < 0) {
                dx2 = -1;
            } else if (w > 0) {
                dx2 = 1;
            }
            int longest = Math.abs(w);
            int shortest = Math.abs(h);
            if (longest <= shortest) {
                longest = Math.abs(h);
                shortest = Math.abs(w);
                if (h < 0) {
                    dy2 = -1;
                } else if (h > 0) {
                    dy2 = 1;
                }
                dx2 = 0;
            }
            int numerator = longest >> 1;
            for (int i = 0; i <= longest; ++i) {
                this.fastBitmap.setGray(x, y, this.gray);
                if ((numerator += shortest) >= longest) {
                    numerator -= longest;
                    x += dx1;
                    y += dy1;
                    continue;
                }
                x += dx2;
                y += dy2;
            }
        }
    }

    public void DrawImage(FastBitmap image, int x, int y) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (image.getCoordinateSystem() == FastBitmap.CoordinateSystem.Matrix) {
            if (image.isGrayscale()) {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        this.fastBitmap.setGray(i + x, j + y, image.getGray(i, j));
                    }
                }
            } else if (image.isRGB()) {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        this.fastBitmap.setRGB(i + x, j + y, image.getRGB(i, j));
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        this.fastBitmap.setARGB(i + x, j + y, image.getARGB(i, j));
                    }
                }
            }
        } else if (image.isGrayscale()) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    this.fastBitmap.setGray(j + x, i + y, image.getGray(j, i));
                }
            }
        } else if (image.isRGB()) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    this.fastBitmap.setRGB(j + x, i + y, image.getRGB(j, i));
                }
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    this.fastBitmap.setARGB(j + x, i + y, image.getARGB(j, i));
                }
            }
        }
    }

    public void DrawPolygon(IntPolygon polygon) {
        this.DrawPolygon(polygon.getX(), polygon.getY());
    }

    public void DrawPolygon(IntPolygon polygon, int nPoints) {
        this.DrawPolygon(polygon.getX(), polygon.getY(), nPoints);
    }

    public void DrawPolygon(List<IntPoint> points, int n) {
        if (points.size() > 2 && n > 2) {
            for (int i = 1; i < n; ++i) {
                this.DrawLine(points.get(i), points.get(i - 1));
            }
        } else {
            throw new IllegalArgumentException("Draw Polygon needs at least 3 points.");
        }
        this.DrawLine(points.get(n - 1), points.get(0));
    }

    public void DrawPolygon(List<IntPoint> points) {
        this.DrawPolygon(points, points.size());
    }

    public void DrawPolygon(int[] x, int[] y) {
        this.DrawPolygon(x, y, x.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void DrawPolygon(int[] x, int[] y, int n) {
        if (x.length <= 2 || y.length <= 2) throw new IllegalArgumentException("Draw Polygon: X and Y needs at least 3 points.");
        if (x.length != y.length) throw new IllegalArgumentException("Draw Polygon: X and Y must be the same size.");
        for (int i = 1; i < n; ++i) {
            this.DrawLine(x[i], y[i], x[i - 1], y[i - 1]);
        }
        this.DrawLine(x[n - 1], y[n - 1], x[0], y[0]);
    }

    public void DrawRectangle(IntRectangle rectangle) {
        this.DrawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void DrawRectangle(IntPoint p, int width, int height) {
        this.DrawRectangle(p.x, p.y, width, height);
    }

    public void DrawRectangle(int x, int y, int width, int height) {
        if (this.fastBitmap.isRGB()) {
            int j;
            for (j = y; j < y + width; ++j) {
                this.fastBitmap.setRGB(x, j, this.color);
            }
            for (j = y; j < y + width; ++j) {
                this.fastBitmap.setRGB(x + height, j, this.color);
            }
            for (int i = x; i < x + height; ++i) {
                this.fastBitmap.setRGB(i, y, this.color);
                this.fastBitmap.setRGB(i, y + width, this.color);
            }
        } else {
            int j;
            for (j = y; j < y + width; ++j) {
                this.fastBitmap.setGray(x, j, this.gray);
            }
            for (j = y; j < y + width; ++j) {
                this.fastBitmap.setGray(x + height, j, this.gray);
            }
            for (int i = x; i < x + height; ++i) {
                this.fastBitmap.setGray(i, y, this.gray);
                this.fastBitmap.setGray(i, y + width, this.gray);
            }
        }
    }
}

