/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners;

import Catalano.Core.IntPoint;
import Catalano.Imaging.Corners.ICornersDetector;
import Catalano.Imaging.FastBitmap;
import java.util.ArrayList;
import java.util.List;

public class SusanCornersDetector
implements ICornersDetector {
    private int differenceThreshold = 25;
    private int geometricalThreshold = 18;
    private List<IntPoint> corners = new ArrayList<IntPoint>();
    private int[] rowRadius = new int[]{1, 2, 3, 3, 3, 2, 1};

    public SusanCornersDetector() {
    }

    public SusanCornersDetector(int differenceThreshold, int geometricalThreshold) {
        this.differenceThreshold = differenceThreshold;
        this.geometricalThreshold = geometricalThreshold;
    }

    public int getDifferenceThreshold() {
        return this.differenceThreshold;
    }

    public void setDifferenceThreshold(int differenceThreshold) {
        this.differenceThreshold = differenceThreshold;
    }

    public int getGeometricalThreshold() {
        return this.geometricalThreshold;
    }

    public void setGeometricalThreshold(int geometricalThreshold) {
        this.geometricalThreshold = geometricalThreshold;
    }

    @Override
    public List<IntPoint> ProcessImage(FastBitmap fastBitmap) {
        int y;
        int x;
        FastBitmap l = new FastBitmap(fastBitmap);
        if (fastBitmap.isRGB()) {
            l.toGrayscale();
        }
        int width = l.getWidth();
        int height = l.getHeight();
        int[][] susanMap = new int[height][width];
        for (x = 3; x < height - 3; ++x) {
            for (y = 3; y < width - 3; ++y) {
                int nucleusValue = l.getGray(x, y);
                int usan = 0;
                int cx = 0;
                int cy = 0;
                for (int i = -3; i <= 3; ++i) {
                    int r = this.rowRadius[i + 3];
                    for (int j = -r; j <= r; ++j) {
                        int gray = l.getGray(x + i, y + j);
                        if (Math.abs(nucleusValue - gray) > this.differenceThreshold) continue;
                        ++usan;
                        cx += x + j;
                        cy += y + i;
                    }
                }
                usan = usan < this.geometricalThreshold ? (x != (cx /= usan) || y != (cy /= usan) ? this.geometricalThreshold - usan : 0) : 0;
                susanMap[x][y] = usan;
            }
        }
        for (x = 2; x < height - 2; ++x) {
            for (y = 2; y < width - 2; ++y) {
                int currentValue = susanMap[x][y];
                block6: for (int i = -2; currentValue != 0 && i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        if (susanMap[x + i][y + j] <= currentValue) continue;
                        currentValue = 0;
                        continue block6;
                    }
                }
                if (currentValue == 0) continue;
                this.corners.add(new IntPoint(x, y));
            }
        }
        return this.corners;
    }
}

