/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Grayscale
implements IApplyInPlace {
    private double redCoefficient = 0.2125;
    private double greenCoefficient = 0.7154;
    private double blueCoefficient = 0.0721;
    private FastBitmap result;
    private Algorithm grayscaleMethod = Algorithm.Luminosity;
    private boolean isAlgorithm = false;

    public Grayscale() {
    }

    public Grayscale(double redCoefficient, double greenCoefficient, double blueCoefficient) {
        this.redCoefficient = redCoefficient;
        this.greenCoefficient = greenCoefficient;
        this.blueCoefficient = blueCoefficient;
        this.isAlgorithm = false;
    }

    public Grayscale(Algorithm grayscaleMethod) {
        this.grayscaleMethod = grayscaleMethod;
        this.isAlgorithm = true;
    }

    public double getRedCoefficient() {
        return this.redCoefficient;
    }

    public void setRedCoefficient(double redCoefficient) {
        this.redCoefficient = redCoefficient;
    }

    public double getGreenCoefficient() {
        return this.greenCoefficient;
    }

    public void setGreenCoefficient(double greenCoefficient) {
        this.greenCoefficient = greenCoefficient;
    }

    public double getBlueCoefficient() {
        return this.blueCoefficient;
    }

    public void setBlueCoefficient(double blueCoefficient) {
        this.blueCoefficient = blueCoefficient;
    }

    public Algorithm getGrayscaleMethod() {
        return this.grayscaleMethod;
    }

    public void setGrayscaleMethod(Algorithm grayscaleMethod) {
        this.grayscaleMethod = grayscaleMethod;
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        if (!fb.isRGB()) {
            throw new IllegalArgumentException("(Concurrent) Grayscale only works in RGB images.");
        }
        this.result = new FastBitmap(fb.getWidth(), fb.getHeight(), FastBitmap.ColorSpace.Grayscale);
        this.Parallel(fb);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int processors = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[processors];
        int part = fastBitmap.getHeight() / processors;
        int last = processors - 1;
        int startX = 0;
        for (i = 0; i < processors; ++i) {
            if (i == last) {
                part = fastBitmap.getHeight() - startX;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX += part)));
            t[i].start();
        }
        try {
            for (i = 0; i < processors; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        fastBitmap.setImage(this.result);
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            if (!Grayscale.this.isAlgorithm) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        double r = this.share.fastBitmap.getRed(x, y);
                        double g = this.share.fastBitmap.getGreen(x, y);
                        double b = this.share.fastBitmap.getBlue(x, y);
                        double gray = r * Grayscale.this.redCoefficient + g * Grayscale.this.greenCoefficient + b * Grayscale.this.blueCoefficient;
                        Grayscale.this.result.setGray(x, y, (int)gray);
                    }
                }
            } else {
                switch (Grayscale.this.grayscaleMethod) {
                    case Lightness: {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double r = this.share.fastBitmap.getRed(x, y);
                                double g = this.share.fastBitmap.getGreen(x, y);
                                double b = this.share.fastBitmap.getBlue(x, y);
                                double max = Math.max(r, g);
                                max = Math.max(max, b);
                                double min = Math.min(r, g);
                                min = Math.min(min, b);
                                double gray = (max + min) / 2.0;
                                Grayscale.this.result.setGray(x, y, (int)gray);
                            }
                        }
                        break;
                    }
                    case Average: {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double r = this.share.fastBitmap.getRed(x, y);
                                double g = this.share.fastBitmap.getGreen(x, y);
                                double b = this.share.fastBitmap.getBlue(x, y);
                                double gray = (r + g + b) / 3.0;
                                Grayscale.this.result.setGray(x, y, (int)gray);
                            }
                        }
                        break;
                    }
                    case GeometricMean: {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double r = this.share.fastBitmap.getRed(x, y);
                                double g = this.share.fastBitmap.getGreen(x, y);
                                double b = this.share.fastBitmap.getBlue(x, y);
                                double gray = Math.pow(r * g * b, 0.33);
                                Grayscale.this.result.setGray(x, y, (int)gray);
                            }
                        }
                        break;
                    }
                    case Luminosity: {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double r = this.share.fastBitmap.getRed(x, y);
                                double g = this.share.fastBitmap.getGreen(x, y);
                                double b = this.share.fastBitmap.getBlue(x, y);
                                double gray = r * 0.2125 + g * 0.7154 + b * 0.0721;
                                Grayscale.this.result.setGray(x, y, (int)gray);
                            }
                        }
                        break;
                    }
                    case MinimumDecomposition: {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double gray = this.share.fastBitmap.getRed(x, y);
                                gray = Math.min(gray, (double)this.share.fastBitmap.getGreen(x, y));
                                gray = Math.min(gray, (double)this.share.fastBitmap.getBlue(x, y));
                                Grayscale.this.result.setGray(x, y, (int)gray);
                            }
                        }
                        break;
                    }
                    case MaximumDecomposition: {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double gray = this.share.fastBitmap.getRed(x, y);
                                gray = Math.max(gray, (double)this.share.fastBitmap.getGreen(x, y));
                                gray = Math.max(gray, (double)this.share.fastBitmap.getBlue(x, y));
                                Grayscale.this.result.setGray(x, y, (int)gray);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static enum Algorithm {
        Lightness,
        Average,
        GeometricMean,
        Luminosity,
        MinimumDecomposition,
        MaximumDecomposition;

    }
}

