/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Desaturation
implements IApplyInPlace {
    private double saturationFactor = 0.2;

    public double getSaturationFactor() {
        return this.saturationFactor;
    }

    public void setSaturationFactor(double saturationFactor) {
        this.saturationFactor = Math.min(1.0, Math.max(0.0, saturationFactor));
    }

    public Desaturation() {
    }

    public Desaturation(double saturationFactor) {
        this.setSaturationFactor(saturationFactor);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isRGB()) {
            throw new IllegalArgumentException("Desaturation only works in RGB space color.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                    double r = this.share.fastBitmap.getRed(i, j);
                    double g = this.share.fastBitmap.getGreen(i, j);
                    double b = this.share.fastBitmap.getBlue(i, j);
                    double luminance = 0.2125 * r + 0.7154 * g + 0.0721 * b;
                    double nr = luminance + Desaturation.this.saturationFactor * (r - luminance);
                    double ng = luminance + Desaturation.this.saturationFactor * (g - luminance);
                    double nb = luminance + Desaturation.this.saturationFactor * (b - luminance);
                    this.share.fastBitmap.setRGB(i, j, (int)nr, (int)ng, (int)nb);
                }
            }
        }
    }
}

