/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Arrays;

public class AlphaTrimmedMean
implements IApplyInPlace {
    private int radius = 1;
    private int trim = 1;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public int getT() {
        return this.trim;
    }

    public void setT(int t) {
        this.trim = Math.max((this.radius * 2 + 1) * (this.radius * 2 + 1) / 2, Math.min(0, t));
    }

    public AlphaTrimmedMean() {
    }

    public AlphaTrimmedMean(int radius) {
        this.setRadius(radius);
    }

    public AlphaTrimmedMean(int radius, int t) {
        this.setRadius(radius);
        this.setT(t);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new Run(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines = this.CalcLines(AlphaTrimmedMean.this.radius);
            int maxArray = lines * lines;
            int safe = AlphaTrimmedMean.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                int[] avgL = new int[maxArray];
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int c = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - AlphaTrimmedMean.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - AlphaTrimmedMean.this.radius);
                                avgL[c] = Xline >= 0 && Xline < this.share.endHeight + safe && Yline >= 0 && Yline < this.share.fastBitmap.getWidth() ? AlphaTrimmedMean.this.copy.getGray(Xline, Yline) : AlphaTrimmedMean.this.copy.getGray(x, y);
                                ++c;
                            }
                        }
                        Arrays.sort(avgL, 0, c);
                        double mean = 0.0;
                        for (int i = AlphaTrimmedMean.this.trim; i < c - AlphaTrimmedMean.this.trim; ++i) {
                            mean += (double)avgL[i];
                        }
                        this.share.fastBitmap.setGray(x, y, (int)(mean / (double)(avgL.length - 2 * AlphaTrimmedMean.this.trim)));
                    }
                }
            } else {
                int[] avgR = new int[maxArray];
                int[] avgG = new int[maxArray];
                int[] avgB = new int[maxArray];
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int c = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - AlphaTrimmedMean.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - AlphaTrimmedMean.this.radius);
                                if (Xline >= 0 && Xline < this.share.endHeight + safe && Yline >= 0 && Yline < this.share.fastBitmap.getWidth()) {
                                    avgR[c] = AlphaTrimmedMean.this.copy.getRed(Xline, Yline);
                                    avgG[c] = AlphaTrimmedMean.this.copy.getGreen(Xline, Yline);
                                    avgB[c] = AlphaTrimmedMean.this.copy.getBlue(Xline, Yline);
                                } else {
                                    avgR[c] = AlphaTrimmedMean.this.copy.getRed(x, y);
                                    avgG[c] = AlphaTrimmedMean.this.copy.getGreen(x, y);
                                    avgB[c] = AlphaTrimmedMean.this.copy.getBlue(x, y);
                                }
                                ++c;
                            }
                        }
                        Arrays.sort(avgR, 0, c);
                        Arrays.sort(avgG, 0, c);
                        Arrays.sort(avgB, 0, c);
                        double meanR = 0.0;
                        double meanG = 0.0;
                        double meanB = 0.0;
                        for (int i = AlphaTrimmedMean.this.trim; i < c - AlphaTrimmedMean.this.trim; ++i) {
                            meanR += (double)avgR[i];
                            meanG += (double)avgG[i];
                            meanB += (double)avgB[i];
                        }
                        this.share.fastBitmap.setRGB(x, y, (int)(meanR /= (double)(avgR.length - 2 * AlphaTrimmedMean.this.trim)), (int)(meanG /= (double)(avgG.length - 2 * AlphaTrimmedMean.this.trim)), (int)(meanB /= (double)(avgB.length - 2 * AlphaTrimmedMean.this.trim)));
                    }
                }
            }
        }

        private int CalcLines(int radius) {
            return radius * 2 + 1;
        }
    }
}

