/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging;

import Catalano.Imaging.FastBitmap;

public class Color {
    public static final Color Black = new Color(0, 0, 0);
    public static final Color Blue = new Color(0, 0, 255);
    public static final Color Cyan = new Color(0, 255, 255);
    public static final Color DarkGray = new Color(64, 64, 64);
    public static final Color Gray = new Color(128, 128, 128);
    public static final Color Green = new Color(0, 255, 0);
    public static final Color LightGray = new Color(192, 192, 192);
    public static final Color Magenta = new Color(255, 0, 255);
    public static final Color Orange = new Color(255, 200, 0);
    public static final Color Pink = new Color(255, 175, 175);
    public static final Color Red = new Color(255, 0, 0);
    public static final Color Yellow = new Color(255, 200, 0);
    public static final Color White = new Color(255, 255, 255);
    public int r = 0;
    public int g = 0;
    public int b = 0;

    public static int toPackedRGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int Count(FastBitmap fastBitmap) {
        int i;
        if (fastBitmap.isGrayscale()) {
            int i2;
            byte[] maxColors = new byte[256];
            int colors = 0;
            byte[] data = fastBitmap.getGrayData();
            for (i2 = 0; i2 < data.length; ++i2) {
                maxColors[data[i2]] = 1;
            }
            for (i2 = 0; i2 < 256; ++i2) {
                if (maxColors[i2] != 1) continue;
                ++colors;
            }
            return colors;
        }
        byte[] maxColors = new byte[0x1000000];
        int colors = 0;
        int[] data = fastBitmap.getRGBData();
        for (i = 0; i < data.length; ++i) {
            maxColors[data[i]] = 1;
        }
        for (i = 0; i < 0x1000000; ++i) {
            if (maxColors[i] != 1) continue;
            ++colors;
        }
        return colors;
    }

    public Color() {
    }

    public Color(int red, int green, int blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    public Color(int[] rgb) {
        this.r = rgb[0];
        this.g = rgb[1];
        this.b = rgb[2];
    }

    public Color(int rgb) {
        this.r = rgb >> 16 & 0xFF;
        this.g = rgb >> 8 & 0xFF;
        this.b = rgb & 0xFF;
    }

    public Color(String hex) {
        String t = hex.substring(5, 7);
        this.r = Integer.parseInt(hex.substring(1, 3), 16);
        this.g = Integer.parseInt(hex.substring(3, 5), 16);
        this.b = Integer.parseInt(hex.substring(5, 7), 16);
    }

    public static boolean isEqual(Color c1, Color c2) {
        return c1.r == c2.r && c1.g == c2.g && c1.b == c2.b;
    }

    public static String toHex(int red, int green, int blue) {
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    public String toHex() {
        return String.format("#%02x%02x%02x", this.r, this.g, this.b);
    }

    public boolean equals(Object obj) {
        Color c2 = (Color)obj;
        return this.r == c2.r && this.g == c2.g && this.b == c2.b;
    }
}

